SELECT
	ds.id           AS id,
	ds.officialname AS name,
	ds.eosc_datasource_type     AS eosc_datasource_type,
	array_agg(a.id) AS apis
FROM
	dsm_services ds
	LEFT OUTER JOIN dsm_api a ON (ds.id = a.service)
WHERE
	ds.eosc_datasource_type = :type AND ds.dedup_main_service = true
GROUP BY
	ds.id, ds.officialname, ds.eosc_datasource_type
ORDER BY
	 ds.officialname