/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.datasources;

import eu.dnetlib.enabling.datasources.MDStoreBackend;
import eu.dnetlib.enabling.datasources.OpenaireDatasource;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import eu.dnetlib.enabling.datasources.common.ApiParamImpl;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.Identity;
import eu.dnetlib.enabling.datasources.common.Organization;
import eu.dnetlib.enabling.datasources.common.PidSystem;
import eu.dnetlib.enabling.datasources.common.SearchApisEntry;
import eu.dnetlib.enabling.datasources.common.SimpleDatasource;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.sql.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatasourceFunctions {
    private static final String EOSC_DATA_SOURCE = "Data Source";
    private static final Log log = LogFactory.getLog(DatasourceFunctions.class);

    public static SimpleDatasource mapToSimpleDs(Map<String, Object> map) {
        SimpleDatasource ds = new SimpleDatasource();
        ds.setId(DatasourceFunctions.castObject(map.get("id"), String.class));
        ds.setName(DatasourceFunctions.castObject(map.get("name"), String.class));
        ds.setOrigId(DatasourceFunctions.castObject(map.get("id"), String.class));
        ds.setEoscDatasourceType(DatasourceFunctions.castObject(map.get("eosc_datasource_type"), String.class));
        ds.setValid(true);
        ds.setPrimaryProvideGateway(DatasourceFunctions.castObject(map.get("primary_provide_gateway"), String.class));
        ds.setAffiliatedProvideGateways(Arrays.stream(DatasourceFunctions.castObject(map.get("affiliated_provide_gateways"), String.class).split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet()));
        try {
            Array arr = DatasourceFunctions.castObject(map.get("apis"), Array.class);
            if (arr != null && ((Object[])arr.getArray()).length > 0) {
                ds.setApis(Arrays.stream((Object[])arr.getArray()).filter(Objects::nonNull).map(Object::toString).collect(Collectors.toSet()));
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error parsing array (apis)", (Throwable)e);
            throw new RuntimeException("Error parsing array (apis)", e);
        }
        return ds;
    }

    public static Datasource<Organization<?>, Identity, PidSystem> mapToDatasource(Map<String, Object> map) {
        OpenaireDatasource ds = new OpenaireDatasource();
        ds.setId(DatasourceFunctions.castObject(map.get("id"), String.class));
        ds.setOfficialname(DatasourceFunctions.castObject(map.get("officialname"), String.class));
        ds.setEnglishname(DatasourceFunctions.castObject(map.get("englishname"), String.class));
        ds.setWebsiteurl(DatasourceFunctions.castObject(map.get("websiteurl"), String.class));
        ds.setLogourl(DatasourceFunctions.castObject(map.get("logourl"), String.class));
        ds.setContactemail(DatasourceFunctions.castObject(map.get("contactemail"), String.class));
        ds.setLatitude(DatasourceFunctions.castObject(map.get("latitude"), Double.class));
        ds.setLongitude(DatasourceFunctions.castObject(map.get("longitude"), Double.class));
        ds.setTimezone(DatasourceFunctions.castObject(map.get("timezone"), String.class));
        ds.setNamespaceprefix(DatasourceFunctions.castObject(map.get("namespaceprefix"), String.class));
        ds.setLanguages(DatasourceFunctions.castObject(map.get("languages"), String.class));
        ds.setCollectedfrom(DatasourceFunctions.castObject(map.get("collectedfrom"), String.class));
        ds.setDateofvalidation(DatasourceFunctions.castObject(map.get("dateofvalidation"), Date.class));
        ds.setEoscDatasourceType(DatasourceFunctions.castObject(map.get("eosc_datasource_type"), String.class));
        ds.setProvenanceaction(DatasourceFunctions.castObject(map.get("provenanceaction"), String.class));
        ds.setDateofcollection(DatasourceFunctions.castObject(map.get("dateofcollection"), Date.class));
        ds.setPlatform(DatasourceFunctions.castObject(map.get("platform"), String.class));
        ds.setActivationId(DatasourceFunctions.castObject(map.get("activationId"), String.class));
        ds.setDescription(DatasourceFunctions.castObject(map.get("description"), String.class));
        ds.setReleasestartdate(DatasourceFunctions.castObject(map.get("releasestartdate"), Date.class));
        ds.setReleaseenddate(DatasourceFunctions.castObject(map.get("releaseenddate"), Date.class));
        ds.setMissionstatementurl(DatasourceFunctions.castObject(map.get("missionstatementurl"), String.class));
        ds.setDatabaseaccesstype(DatasourceFunctions.castObject(map.get("databaseaccesstype"), String.class));
        ds.setDatauploadtype(DatasourceFunctions.castObject(map.get("datauploadtype"), String.class));
        ds.setDatabaseaccessrestriction(DatasourceFunctions.castObject(map.get("databaseaccessrestriction"), String.class));
        ds.setDatauploadrestriction(DatasourceFunctions.castObject(map.get("datauploadrestriction"), String.class));
        ds.setCitationguidelineurl(DatasourceFunctions.castObject(map.get("citationguidelineurl"), String.class));
        ds.setCertificates(DatasourceFunctions.castObject(map.get("certificates"), String.class));
        ds.setAggregator(DatasourceFunctions.castObject(map.get("aggregator"), String.class));
        ds.setIssn(DatasourceFunctions.castObject(map.get("issn"), String.class));
        ds.setEissn(DatasourceFunctions.castObject(map.get("eissn"), String.class));
        ds.setLissn(DatasourceFunctions.castObject(map.get("lissn"), String.class));
        ds.setRegisteredby(DatasourceFunctions.castObject(map.get("registeredby"), String.class));
        ds.setSubjects(DatasourceFunctions.castObject(map.get("subjects"), String.class));
        ds.setManaged(DatasourceFunctions.castObject(map.get("managed"), Boolean.class));
        ds.setConsentTermsOfUse(DatasourceFunctions.castObject(map.get("consenttermsofuse"), Boolean.class));
        ds.setConsentTermsOfUseDate(DatasourceFunctions.castObject(map.get("consenttermsofusedate"), Date.class));
        ds.setFullTextDownload(DatasourceFunctions.castObject(map.get("fulltextdownload"), Boolean.class));
        ds.setStatus(DatasourceFunctions.castObject(map.get("status"), String.class));
        ds.setPrimaryProvideGateway(DatasourceFunctions.castObject(map.get("primary_provide_gateway"), String.class));
        ds.setAffiliatedProvideGateways(DatasourceFunctions.castObject(map.get("affiliated_provide_gateways"), String.class).split(","));
        return ds;
    }

    public static Identity mapToDsIdentity(Map<String, Object> map) {
        Identity id = new Identity();
        id.setPid(DatasourceFunctions.castObject(map.get("pid"), String.class));
        id.setIssuertype(DatasourceFunctions.castObject(map.get("issuertype"), String.class));
        return id;
    }

    public static Organization<Datasource<?, ?, ?>> mapToDsOrganization(Map<String, Object> map) {
        Organization org = new Organization();
        org.setId(DatasourceFunctions.castObject(map.get("id"), String.class));
        org.setLegalshortname(DatasourceFunctions.castObject(map.get("legalshortname"), String.class));
        org.setLegalname(DatasourceFunctions.castObject(map.get("legalname"), String.class));
        org.setWebsiteurl(DatasourceFunctions.castObject(map.get("websiteurl"), String.class));
        org.setLogourl(DatasourceFunctions.castObject(map.get("logourl"), String.class));
        org.setCountry(DatasourceFunctions.castObject(map.get("country"), String.class));
        org.setCollectedfrom(DatasourceFunctions.castObject(map.get("collectedfrom"), String.class));
        org.setDateofcollection(DatasourceFunctions.castObject(map.get("dateofcollection"), Date.class));
        org.setProvenanceaction(DatasourceFunctions.castObject(map.get("provenanceaction"), String.class));
        return org;
    }

    public static SearchApisEntry mapToSearchApisEntry(Map<String, Object> map) {
        Timestamp t;
        SearchApisEntry a = new SearchApisEntry();
        a.setId(DatasourceFunctions.castObject(map.get("id"), String.class));
        a.setCompliance(DatasourceFunctions.castObject(map.get("compliance"), String.class));
        a.setActive(DatasourceFunctions.castObject(map.get("active"), Boolean.class).booleanValue());
        a.setRepoId(DatasourceFunctions.castObject(map.get("dsId"), String.class));
        a.setRepoName(DatasourceFunctions.castObject(map.get("name"), String.class));
        a.setRepoCountry(DatasourceFunctions.castObject(map.get("country"), String.class));
        a.setRepoPrefix(DatasourceFunctions.castObject(map.get("prefix"), String.class));
        if (map.get("aggrDate") != null) {
            t = DatasourceFunctions.castObject(map.get("aggrDate"), Timestamp.class);
            a.setAggrDate(DateUtils.calculate_ISO8601((long)t.getTime()));
        } else {
            a.setAggrDate("");
        }
        a.setAggrTotal(DatasourceFunctions.castObject(map.get("aggrTotal"), Integer.class).intValue());
        a.setAggrBackend(DatasourceFunctions.calculateMdstoreBackendById(DatasourceFunctions.castObject(map.get("aggrMdId"), String.class)));
        if (map.get("collDate") != null) {
            t = DatasourceFunctions.castObject(map.get("collDate"), Timestamp.class);
            a.setCollDate(DateUtils.calculate_ISO8601((long)t.getTime()));
        } else {
            a.setCollDate("");
        }
        a.setCollTotal(DatasourceFunctions.castObject(map.get("collTotal"), Integer.class).intValue());
        a.setCollBackend(DatasourceFunctions.calculateMdstoreBackendById(DatasourceFunctions.castObject(map.get("collMdId"), String.class)));
        a.setProtocol(DatasourceFunctions.castObject(map.get("protocol"), String.class));
        a.setAlternativeName(DatasourceFunctions.castObject(map.get("alternativeName"), String.class));
        a.setRepoOrganization(DatasourceFunctions.castObject(map.get("organization"), String.class));
        a.setPrimaryProvideGateway(DatasourceFunctions.castObject(map.get("primary_provide_gateway"), String.class));
        a.setAffiliatedProvideGateways(Arrays.stream(DatasourceFunctions.castObject(map.get("affiliated_provide_gateways"), String.class).split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet()));
        return a;
    }

    public static String calculateMdstoreBackendById(String mdId) {
        if (StringUtils.isBlank((CharSequence)mdId)) {
            return "";
        }
        if (StringUtils.trim((String)mdId).startsWith("md-") && StringUtils.trim((String)mdId).length() <= 40) {
            return MDStoreBackend.HDFS.toString();
        }
        return MDStoreBackend.MONGO.toString();
    }

    public static Api<ApiParam> mapToApi(Map<String, Object> map) {
        Api a = new Api();
        a.setId(DatasourceFunctions.castObject(map.get("id"), String.class));
        a.setProtocol(DatasourceFunctions.castObject(map.get("protocol"), String.class));
        a.setDatasource(DatasourceFunctions.castObject(map.get("datasource"), String.class));
        a.setContentdescription(DatasourceFunctions.castObject(map.get("contentdescription"), String.class));
        a.setActive(DatasourceFunctions.castObject(map.get("active"), Boolean.class));
        a.setRemovable(DatasourceFunctions.castObject(map.get("removable"), Boolean.class));
        a.setCompatibility(DatasourceFunctions.castObject(map.get("compatibility"), String.class));
        a.setCompatibilityOverrided(DatasourceFunctions.castObject(map.get("isCompatibilityOverrided"), Boolean.class).booleanValue());
        a.setMetadataIdentifierPath(DatasourceFunctions.castObject(map.get("metadataIdentifierPath"), String.class));
        a.setLastCollectionTotal(DatasourceFunctions.castObject(map.get("lastCollectionTotal"), Integer.class));
        a.setLastCollectionDate(DatasourceFunctions.castObject(map.get("lastCollectionDate"), Timestamp.class));
        a.setLastCollectionMdid(DatasourceFunctions.castObject(map.get("lastCollectionMdid"), String.class));
        a.setLastAggregationTotal(DatasourceFunctions.castObject(map.get("lastAggregationTotal"), Integer.class));
        a.setLastAggregationDate(DatasourceFunctions.castObject(map.get("lastAggregationDate"), Timestamp.class));
        a.setLastAggregationMdid(DatasourceFunctions.castObject(map.get("lastAggregationMdid"), String.class));
        a.setLastDownloadTotal(DatasourceFunctions.castObject(map.get("lastDownloadTotal"), Integer.class));
        a.setLastDownloadDate(DatasourceFunctions.castObject(map.get("lastDownloadDate"), Timestamp.class));
        a.setLastDownloadObjid(DatasourceFunctions.castObject(map.get("lastDownloadObjid"), String.class));
        a.setLastValidationJob(DatasourceFunctions.castObject(map.get("lastValidationJob"), String.class));
        a.setBaseurl(DatasourceFunctions.castObject(map.get("baseUrl"), String.class));
        try {
            Array arr = DatasourceFunctions.castObject(map.get("params"), Array.class);
            if (arr != null) {
                a.setApiParams(Arrays.stream((Object[])arr.getArray()).filter(Objects::nonNull).map(Object::toString).map(s -> {
                    ApiParamImpl p = new ApiParamImpl();
                    p.setParam(StringUtils.substringBefore((String)s, (String)"="));
                    p.setValue(StringUtils.substringAfter((String)s, (String)"="));
                    return p;
                }).collect(Collectors.toSet()));
            }
        }
        catch (SQLException e) {
            log.error((Object)"Error parsing array params", (Throwable)e);
            throw new RuntimeException("Error parsing array params", e);
        }
        return a;
    }

    public static Map<String, Object> dsToMap(Datasource<Organization<?>, Identity, PidSystem> ds) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ds.getId());
        map.put("officialname", ds.getOfficialname());
        map.put("englishname", ds.getEnglishname());
        map.put("websiteurl", ds.getWebsiteurl());
        map.put("logourl", ds.getLogourl());
        map.put("contactemail", ds.getContactemail());
        map.put("latitude", ds.getLatitude());
        map.put("longitude", ds.getLongitude());
        map.put("timezone", ds.getTimezone());
        map.put("namespaceprefix", ds.getNamespaceprefix());
        map.put("languages", ds.getLanguages());
        map.put("collectedfrom", ds.getCollectedfrom());
        map.put("dateofvalidation", ds.getDateofvalidation());
        map.put("eosctype", EOSC_DATA_SOURCE);
        map.put("eoscdatasourcetype", ds.getEoscDatasourceType());
        map.put("provenanceaction", ds.getProvenanceaction());
        map.put("platform", ds.getPlatform());
        map.put("activationid", ds.getActivationId());
        map.put("description", ds.getDescription());
        map.put("releasestartdate", ds.getReleasestartdate());
        map.put("releaseenddate", ds.getReleaseenddate());
        map.put("missionstatementurl", ds.getMissionstatementurl());
        map.put("databaseaccesstype", ds.getDatabaseaccesstype());
        map.put("datauploadtype", ds.getDatauploadtype());
        map.put("databaseaccessrestriction", ds.getDatabaseaccessrestriction());
        map.put("datauploadrestriction", ds.getDatauploadrestriction());
        map.put("citationguidelineurl", ds.getCitationguidelineurl());
        map.put("pidsystems", ds.getPidsystems());
        map.put("certificates", ds.getCertificates());
        map.put("aggregator", ds.getAggregator());
        map.put("issn", ds.getIssn());
        map.put("eissn", ds.getEissn());
        map.put("lissn", ds.getLissn());
        map.put("registeredby", ds.getRegisteredby());
        map.put("subjects", ds.getSubjects());
        map.put("managed", ds.getManaged());
        map.put("status", ds.getStatus());
        map.put("primaryprovidegateway", ds.getPrimaryProvideGateway());
        map.put("affiliatedprovidegateways", StringUtils.join((Object[])ds.getAffiliatedProvideGateways(), (String)","));
        return map;
    }

    public static Map<String, Object> orgToMap(String dsId, Organization<?> org) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dsId", dsId);
        map.put("orgId", org.getId());
        map.put("legalname", org.getLegalname());
        map.put("legalshortname", org.getLegalshortname());
        map.put("websiteurl", org.getWebsiteurl());
        map.put("logourl", org.getLogourl());
        map.put("country", org.getCountry());
        map.put("collectedfrom", org.getCollectedfrom());
        return map;
    }

    public static Map<String, Object> apiToMap(Api<?> api) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("apiId", api.getId());
        map.put("protocol", api.getProtocol());
        map.put("baseUrl", api.getBaseurl());
        map.put("dsId", api.getDatasource());
        map.put("contentDescription", api.getContentdescription());
        map.put("compatibility", api.getCompatibility());
        map.put("metadataIdentifierPath", api.getMetadataIdentifierPath());
        map.put("removable", api.getRemovable());
        return map;
    }

    private static <T> T castObject(Object o, Class<T> clazz) {
        if (o == null) {
            return null;
        }
        if (clazz.isInstance(o)) {
            return (T)o;
        }
        throw new IllegalArgumentException("Type not managed: " + clazz.getSimpleName());
    }
}

