package eu.dnetlib.openaire.exporter.model.datasource.db;

import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.swagger.annotations.ApiModel;

/**
 * Created by claudio on 13/04/2017.
 */
@Entity
@Table(name = "dsm_apiparams")
@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel(value = "Datasource Api params model", description = "describes the datasource api params")
public class Apiparam {

	@JsonIgnore
	@EmbeddedId
	private ApiParamKey id;

	private String value;

	public Apiparam() {}

	public ApiParamKey getId() {
		return id;
	}

	public Apiparam setId(final ApiParamKey id) {
		this.id = id;
		return this;
	}

	public String getValue() {
		return value;
	}

	public void setValue(final String value) {
		this.value = value;
	}

	public String getParam() {
		return id.getParam();
	}

	public void setParam(final String param) {
		getId().setParam(param);
	}

}
