package eu.dnetlib;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import eu.dnetlib.OpenaireExporterConfig.Jdbc;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by claudio on 07/07/2017.
 */
@Configuration
public class DNetOpenaireExporterBeanFactory {

	@Autowired
	private OpenaireExporterConfig config;

	@Bean
	public ISLookUpService getLookUpService() {
		final JaxWsProxyFactoryBean jaxWsProxyFactory = new JaxWsProxyFactoryBean();
		jaxWsProxyFactory.setServiceClass(ISLookUpService.class);
		jaxWsProxyFactory.setAddress(config.getIsLookupUrl());
		return (ISLookUpService) jaxWsProxyFactory.create();
	}

	@Bean
	public BasicDataSource getProjectDataSource() {
		final Jdbc jdbc = config.getJdbc();
		return getDatasource(
				jdbc.getDriverClassName(),
				jdbc.getUrl(),
				jdbc.getUser(),
				jdbc.getPwd(),
				jdbc.getMinIdle(),
				jdbc.getMaxRows());
	}

	private BasicDataSource getDatasource(String driverClassName, String jdbcUrl, String jdbcUser, String jdbcPwd, int jdbcMinIdle, int jdbcMaxIdle) {
		final BasicDataSource d = new BasicDataSource();
		d.setDriverClassName(driverClassName);
		d.setUrl(jdbcUrl);
		d.setUsername(jdbcUser);
		d.setPassword(jdbcPwd);
		d.setMinIdle(jdbcMinIdle);
		d.setMaxIdle(jdbcMaxIdle);
		return d;
	}

	@Bean
	public MongoClient getMongoClient() {
		return new MongoClient(
				new ServerAddress(config.getDatasource().getMongoHost(), config.getDatasource().getMongoPort()),
				MongoClientOptions.builder().connectionsPerHost(config.getDatasource().getMongoConnectionsPerHost()).build());
	}


}
