package eu.dnetlib.openaire.exporter.datasource.repository;

import java.util.List;

import eu.dnetlib.openaire.exporter.model.datasource.db.Api;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

/**
 * Created by claudio on 15/06/2017.
 */
@Repository
public interface ApiRepository extends JpaRepository<Api, String> {

	String ID_PREFIX = "api_________::";

	static String createId(Api api) {
		return ID_PREFIX + api.getDatasource() + "::" + RandomStringUtils.randomAlphanumeric(8);
	}

	@Query("select a from Api a where a.datasource = ?1")
	List<Api> findByDatasource(String dsId);
}
