package eu.dnetlib.openaire.exporter.datasource.repository;

import javax.transaction.Transactional;

import eu.dnetlib.openaire.exporter.model.datasource.db.Datasource;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Repository;
import org.springframework.util.concurrent.ListenableFuture;

/**
 * Created by claudio on 12/04/2017.
 */
@Repository
public interface DatasourceRepository extends JpaRepository<Datasource, String> {

	@Async
	ListenableFuture<Datasource> findOneById(String id);

	@Async
	ListenableFuture<Slice<Datasource>> findByOfficialnameContainingOrEnglishnameContainingAllIgnoreCase(String officialname,
			String englishname,
			Pageable pageable);

	@Async
	ListenableFuture<Slice<Datasource>> findByContactemailContainingAllIgnoreCase(String contactemail, Pageable pageable);

	@Async
	ListenableFuture<Slice<Datasource>> findByOrganizationsCountryIgnoreCase(String country, Pageable pageable);

	@Modifying
	@Transactional
	@Query("update Datasource d set d.managed = ?2 where d.id = ?1")
	void setManaged(String id, boolean managed);

	@Modifying
	@Transactional
	@Query("update Datasource d set d.officialname = ?2 where d.id = ?1")
	void setOfficialname(String id, String officialname);

	@Modifying
	@Transactional
	@Query("update Datasource d set d.englishname = ?2 where d.id = ?1")
	void setEnglishname(String id, String englishname);

	@Modifying
	@Transactional
	@Query("update Datasource d set d.latitude = ?2 where d.id = ?1")
	void setLatitude(String id, Double latitude);

	@Modifying
	@Transactional
	@Query("update Datasource d set d.longitude = ?2 where d.id = ?1")
	void setLongitude(String id, Double longitude);

}
