/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.datasource;

import eu.dnetlib.common.rmi.DNetRestDocumentation;
import eu.dnetlib.openaire.exporter.AbstractExporterController;
import eu.dnetlib.openaire.exporter.datasource.ApiException;
import eu.dnetlib.openaire.exporter.datasource.DatasourcesApi;
import eu.dnetlib.openaire.exporter.datasource.clients.ClientResponse;
import eu.dnetlib.openaire.exporter.datasource.clients.DatasourceDao;
import eu.dnetlib.openaire.exporter.model.datasource.BrowseTerm;
import eu.dnetlib.openaire.exporter.model.datasource.DatasourceResponse;
import eu.dnetlib.openaire.exporter.model.datasource.db.Api;
import eu.dnetlib.openaire.exporter.model.datasource.db.Datasource;
import eu.dnetlib.openaire.exporter.model.datasource.db.SearchInterfacesEntry;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@DNetRestDocumentation
public class DatasourcesApiController
extends AbstractExporterController
implements DatasourcesApi {
    private static final Log log = LogFactory.getLog(DatasourcesApiController.class);
    @Autowired
    private DatasourceDao dsDao;

    @RequestMapping(value={"/ds/list/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.GET})
    public List<String> listIds(@PathVariable int page, @PathVariable int size) throws ApiException {
        return this.dsDao.listIds((Pageable)new PageRequest(page, size));
    }

    @RequestMapping(value={"/ds/get/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    public DatasourceResponse getDs(@PathVariable String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("getDatasourceInfo(dsId = %s)", id));
        }
        ClientResponse clientResponse = this.dsDao.getInfo(id);
        return clientResponse.getDatasourceResponse();
    }

    @RequestMapping(value={"/ds/search/name/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.GET})
    public List<DatasourceResponse> searchByName(@RequestParam String name, @PathVariable int page, @PathVariable int size) {
        return this.dsDao.searchByName(name, (Pageable)new PageRequest(page, size));
    }

    @RequestMapping(value={"/ds/search/email/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.GET})
    public List<DatasourceResponse> searchByContactemail(@RequestParam String contactemail, @PathVariable int page, @PathVariable int size) {
        return this.dsDao.searchByContactemail(contactemail, (Pageable)new PageRequest(page, size));
    }

    @RequestMapping(value={"/ds/search/country/{page}/{size}"}, produces={"application/json"}, method={RequestMethod.GET})
    public List<DatasourceResponse> searchByCountry(@RequestParam String country, @PathVariable int page, @PathVariable int size) {
        return this.dsDao.searchByCountry(country, (Pageable)new PageRequest(page, size));
    }

    @RequestMapping(value={"/api/search/{field}"}, produces={"application/json"}, method={RequestMethod.GET})
    public List<SearchInterfacesEntry> searchInterface(@PathVariable String field, @RequestParam String value) {
        return this.dsDao.searchInterface(field, value);
    }

    @RequestMapping(value={"/api/browse/{field}"}, produces={"application/json"}, method={RequestMethod.GET})
    public List<? extends BrowseTerm> browseField(@PathVariable String field) throws ApiException {
        switch (field) {
            case "country": {
                return this.dsDao.browseCountries();
            }
            case "typology": {
                return this.dsDao.browseTypologies();
            }
            case "protocol": {
                return this.dsDao.browseProtocols();
            }
            case "compatibility": {
                return this.dsDao.browseCompatibility();
            }
            case "activation": {
                return this.dsDao.browseActivation();
            }
        }
        throw new ApiException(400, String.format("unsupported browse field '%s'", field));
    }

    @RequestMapping(value={"/ds/api/{dsId}"}, produces={"application/json"}, method={RequestMethod.GET})
    public List<Api> getApi(@PathVariable String dsId) throws ApiException {
        return this.dsDao.getApi(dsId);
    }

    @RequestMapping(value={"/ds/api/{dsId}"}, method={RequestMethod.DELETE})
    public void deleteApi(@PathVariable String apiId) throws ApiException {
        this.dsDao.deleteApi(apiId);
    }

    @RequestMapping(value={"/ds/api/add"}, method={RequestMethod.POST})
    public void addApi(@RequestParam Api api) throws ApiException {
        if (StringUtils.isBlank((String)api.getDatasource())) {
            throw new ApiException(400, "missing datasource id");
        }
        this.dsDao.addApi(api);
    }

    @RequestMapping(value={"/ds/manage"}, method={RequestMethod.POST})
    public void setManaged(@RequestParam String id, @RequestParam boolean managed) {
        this.dsDao.setManaged(id, managed);
    }

    @RequestMapping(value={"/ds/add"}, method={RequestMethod.POST})
    public void saveDatasource(@RequestBody Datasource datasource) throws ApiException {
        if (this.dsDao.exist(datasource)) {
            throw new ApiException(409, String.format("cannot already defined '%s'", datasource.getId()));
        }
        this.dsDao.save(datasource);
    }

    @RequestMapping(value={"/ds/update/officialname"}, method={RequestMethod.POST})
    public void updateOfficialname(@RequestParam String dsId, @RequestParam String officialname) throws ApiException {
        this.dsDao.updateOfficialName(dsId, officialname);
    }

    @RequestMapping(value={"/ds/update/englishname"}, method={RequestMethod.POST})
    public void updateEnglishname(@RequestParam String dsId, @RequestParam String englishname) throws ApiException {
        this.dsDao.updateEnglishName(dsId, englishname);
    }

    @RequestMapping(value={"/ds/update/latitude"}, method={RequestMethod.POST})
    public void updateLatitude(String dsId, Double latitude) throws ApiException {
        this.dsDao.updateLatitude(dsId, latitude);
    }

    @RequestMapping(value={"/ds/update/longitude"}, method={RequestMethod.POST})
    public void updateLongitude(String dsId, Double longitude) throws ApiException {
        this.dsDao.updateLongitude(dsId, longitude);
    }
}

