/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.project;

import eu.dnetlib.openaire.exporter.project.ProjectQueryParams;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class ProjectQueryParamsFactory {
    private static final String BASE_PATH = "/export/";
    private static final String NO_FILTER = "ALL";

    public ProjectQueryParams generateParams(HttpServletRequest request, String startFrom, String startUntil, String endFrom, String endUntil) {
        String substream;
        ProjectQueryParams params = new ProjectQueryParams();
        String[] arr = request.getServletPath().replace(BASE_PATH, "").split("\\/");
        if (arr.length != 5) {
            throw new IllegalArgumentException("Invalid url");
        }
        params.setFundingProgramme(arr[0]);
        String stream = NO_FILTER.equals(arr[1]) ? null : arr[1];
        String string = substream = NO_FILTER.equals(arr[2]) ? null : arr[2];
        if (substream == null) {
            params.setFundingPath(stream);
        } else {
            if (stream == null) {
                stream = "%";
            }
            params.setFundingPath(stream + "::" + substream);
        }
        params.setStartFrom(startFrom);
        params.setStartUntil(startUntil);
        params.setEndFrom(endFrom);
        params.setEndUntil(endUntil);
        return params;
    }
}

