package eu.dnetlib.openaire.exporter.datasource;

import java.util.List;

import eu.dnetlib.openaire.exporter.model.datasource.BrowseTerm;
import eu.dnetlib.openaire.exporter.model.datasource.DatasourceResponse;
import eu.dnetlib.openaire.exporter.model.datasource.Response;
import eu.dnetlib.openaire.exporter.model.datasource.db.Api;
import eu.dnetlib.openaire.exporter.model.datasource.db.Datasource;
import eu.dnetlib.openaire.exporter.model.datasource.db.SearchInterfacesEntry;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;

@io.swagger.annotations.Api(value = "datasources", description = "the datasource manager API")
public interface DatasourcesApi {

    @ApiOperation(value = "list identifiers", notes = "List the Datasource identifiers.", response = List.class)
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = String[].class),
        @ApiResponse(code = 500, message = "unexpected error", response = Response.class) })
    List<String> listIds(int page, int size) throws ApiException;

    @ApiOperation(value = "get datasource by id", notes = "Returns Datasource details.", response = DatasourceResponse.class)
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = DatasourceResponse[].class),
        @ApiResponse(code = 500, message = "unexpected error", response = Response.class) })
    DatasourceResponse getDs(String id);

    @ApiOperation(value = "search datasources by name", notes = "Returns list of Datasource details.", response = DatasourceResponse[].class)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = DatasourceResponse[].class),
            @ApiResponse(code = 500, message = "unexpected error", response = Response.class) })
    List<DatasourceResponse> searchByName(String name, int page, int size);

    @ApiOperation(value = "search datasources by contact email", notes = "Returns list of Datasource details.", response = DatasourceResponse[].class)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = DatasourceResponse[].class),
            @ApiResponse(code = 500, message = "unexpected error", response = Response.class) })
    List<DatasourceResponse> searchByContactemail(String contactemail, int page, int size);

    @ApiOperation(value = "search datasources by country", notes = "Returns list of Datasource details.", response = DatasourceResponse[].class)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = DatasourceResponse[].class),
            @ApiResponse(code = 500, message = "unexpected error", response = Response.class) })
    List<DatasourceResponse> searchByCountry(String country, int page, int size);

    @ApiOperation(value = "search among datasource APIs", notes = "Returns Datasource Api details.", response = SearchInterfacesEntry[].class)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = SearchInterfacesEntry[].class),
            @ApiResponse(code = 500, message = "unexpected error", response = Response.class) })
    List<SearchInterfacesEntry> searchInterface(String field, String value);

    @ApiOperation(value = "terms and count for the given field", notes = "Returns the list of BrowseTerms.", response = BrowseTerm[].class)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = BrowseTerm[].class),
            @ApiResponse(code = 500, message = "unexpected error", response = Response.class) })
    List<? extends BrowseTerm> browseField(String field) throws ApiException;

    @ApiOperation(value = "get the list of API for a given datasource", notes = "Returns the list of API for a given datasource.", httpMethod = "GET", response = Api[].class)
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK", response = Api[].class),
            @ApiResponse(code = 500, message = "unexpected error", response = Response.class) })
    List<Api> getApi(String dsId) throws ApiException;

    @ApiOperation(value = "delete an API", notes = "delete an API", httpMethod = "DELETE")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK"),
            @ApiResponse(code = 500, message = "unexpected error") })
    void deleteApi(String apiId) throws ApiException;

    @ApiOperation(value = "adds a new API to one Datasource", notes = "adds an API to one Datasource", httpMethod = "POST")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK"),
            @ApiResponse(code = 500, message = "unexpected error") })
    void addApi(Api api) throws ApiException;

    @ApiOperation(value = "set the managed status for a given datasource", notes = "set the managed status for a given datasource", httpMethod = "POST")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK"),
            @ApiResponse(code = 500, message = "unexpected error") })
    void setManaged(String id, boolean managed);

    @ApiOperation(value = "adds a new Datasource", notes = "adds a new Datasource", httpMethod = "POST")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK"),
            @ApiResponse(code = 500, message = "unexpected error") })
    void saveDatasource(Datasource datasource) throws ApiException;

    @ApiOperation(value = "updates a datasource official name", notes = "updates a datasource official name", httpMethod = "POST")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK"),
            @ApiResponse(code = 500, message = "unexpected error") })
    void updateOfficialname(String dsId, String officialname) throws ApiException;

    @ApiOperation(value = "updates a datasource english name", notes = "updates a datasource english name", httpMethod = "POST")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK"),
            @ApiResponse(code = 500, message = "unexpected error") })
    void updateEnglishname(String dsId, String english) throws ApiException;

    @ApiOperation(value = "updates a datasource latitude", notes = "updates a datasource latitude", httpMethod = "POST")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK"),
            @ApiResponse(code = 500, message = "unexpected error") })
    void updateLatitude(String dsId, Double latitude) throws ApiException;

    @ApiOperation(value = "updates a datasource longitude", notes = "updates a datasource longitude", httpMethod = "POST")
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "OK"),
            @ApiResponse(code = 500, message = "unexpected error") })
    void updateLongitude(String dsId, Double longitude) throws ApiException;

}
