package eu.dnetlib.openaire.exporter.datasource.clients;

import java.nio.charset.Charset;

import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.openaire.exporter.datasource.ApiException;
import eu.dnetlib.openaire.exporter.datasource.clients.utils.IndexDsInfo;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

/**
 * Created by claudio on 20/10/2016.
 */
@Component
public class ISLookupClient {

	private static final Log log = LogFactory.getLog(ISLookupClient.class);

	@Autowired
	private OpenaireExporterConfig config;

	@Autowired
	private ISLookUpService isLookUpService;

	@Cacheable("datasources-is-cache")
	public IndexDsInfo calculateCurrentIndexDsInfo() throws ApiException {
		log.warn("calculateCurrentIndexDsInfo(): not using cache");
		try {
			final String queryUrl = IOUtils.toString(config.getFindSolrIndexUrl().getInputStream(), Charset.defaultCharset());
			final String queryDs = IOUtils.toString(config.getFindIndexDsInfo().getInputStream(), Charset.defaultCharset());

			final String indexBaseUrl = isLookUpService.getResourceProfileByQuery(queryUrl);
			final String[] arr = isLookUpService.getResourceProfileByQuery(queryDs).split("@@@");

			return new IndexDsInfo(indexBaseUrl, arr[0].trim(), arr[1].trim(), arr[2].trim());
		} catch (Exception e) {
			throw new ApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), "Error querying information system");
		}
	}

}
