package eu.dnetlib.openaire.exporter.model.datasource;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import eu.dnetlib.openaire.exporter.model.datasource.db.Datasource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * Created by claudio on 12/09/16.
 */
@JsonAutoDetect
@ApiModel(value = "Datasource response model", description = "provides information about the datasource and its aggregation status")
public class DatasourceResponse {

	@ApiModelProperty(position = 1)
	private long indexRecords;

	@ApiModelProperty(position = 2)
	private String lastIndexingDate;

	@ApiModelProperty(position = 3)
	private Datasource datasource;

	@ApiModelProperty(position = 4)
	private List<AggregationInfo> aggregationHistory;

	@ApiModelProperty(position = 5)
	private AggregationInfo lastCollection;

	@ApiModelProperty(position = 6)
	private AggregationInfo lastTransformation;

	public DatasourceResponse() {
		super();
	}

	public DatasourceResponse setIndexRecords(final long indexRecords) {
		this.indexRecords = indexRecords;
		return this;
	}

	public DatasourceResponse setLastIndexingDate(final String lastIndexingDate) {
		this.lastIndexingDate = lastIndexingDate;
		return this;
	}

	public DatasourceResponse setAggregationHistory(final List<AggregationInfo> aggregationHistory) {
		this.aggregationHistory = aggregationHistory;
		return this;
	}

	public DatasourceResponse setLastCollection(final AggregationInfo lastCollection) {
		this.lastCollection = lastCollection;
		return this;
	}

	public DatasourceResponse setLastTransformation(final AggregationInfo lastTransformation) {
		this.lastTransformation = lastTransformation;
		return this;
	}

	public long getIndexRecords() {
		return indexRecords;
	}

	public String getLastIndexingDate() {
		return lastIndexingDate;
	}

	public List<AggregationInfo> getAggregationHistory() {
		return aggregationHistory;
	}

	public AggregationInfo getLastCollection() {
		return lastCollection;
	}

	public AggregationInfo getLastTransformation() {
		return lastTransformation;
	}

	public Datasource getDatasource() {
		return datasource;
	}

	public void setDatasource(final Datasource datasource) {
		this.datasource = datasource;
	}
}
