package eu.dnetlib.openaire.exporter.model.project;

import java.sql.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import org.apache.commons.lang3.StringUtils;

/**
 * Created by claudio on 05/07/2017.
 */
@Entity
@Table(name = "projects_tsv")
@ApiModel(value = "Project TSV model", description = "project TSV model description")
public class ProjectTsv {

	@Id
	@JsonIgnore
	private String id;
	private String code;
	private String acronym;
	private String title;
	@Column(name = "call_identifier")
	private String callIdentifier;
	private Date startdate;
	private Date enddate;
	@Column(name = "ec_sc39")
	private Boolean ecSc39;
	@Column(name = "oa_mandate_for_publications")
	private Boolean oaMandateForPublications;
	@Column(name = "oa_mandate_for_datasets")
	private Boolean oaMandateForDatasets;
	@JsonIgnore
	private String fundingpathid;
	private String description;
	@Column(name = "legalname")
	private String orgLegalname;
	@Column(name = "country")
	private String orgCountry;
	@Column(name = "role")
	private String orgRole;
	private String firstname;
	private String secondnames;
	private String email;

	public ProjectTsv() {}

	public List<String> asList() {
		return Lists.newArrayList(
				clean(getCode()),
				clean(getAcronym()),
				clean(getTitle()),
				clean(getCallIdentifier()),
				clean(getStartdate() != null ? getStartdate().toString() : ""),
				clean(getEnddate() != null ? getEnddate().toString() : ""),
				clean(String.valueOf(isOaMandateForPublications())),
				clean(String.valueOf(isOaMandateForDatasets())),
				clean(getDescription()),
				clean(getOrgLegalname()),
				clean(getOrgCountry()),
				clean(getOrgRole()),
				clean(getFirstname()),
				clean(getSecondnames()),
				clean(getEmail()));
	}

	private String clean(final String s) {
		return StringUtils.isNotBlank(s) ? "\"" + s.replaceAll("\\n|\\t|\\s+", " ").replace("\"","\"\"").trim() + "\"" : "";
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getCode() {
		return code;
	}

	public void setCode(final String code) {
		this.code = code;
	}

	public String getAcronym() {
		return acronym;
	}

	public void setAcronym(final String acronym) {
		this.acronym = acronym;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(final String title) {
		this.title = title;
	}

	public String getCallIdentifier() {
		return callIdentifier;
	}

	public void setCallIdentifier(final String callIdentifier) {
		this.callIdentifier = callIdentifier;
	}

	public Date getStartdate() {
		return startdate;
	}

	public void setStartdate(final Date startdate) {
		this.startdate = startdate;
	}

	public Date getEnddate() {
		return enddate;
	}

	public void setEnddate(final Date enddate) {
		this.enddate = enddate;
	}

	public Boolean isEcSc39() {
		return ecSc39;
	}

	public void setEcSc39(final Boolean ecSc39) {
		this.ecSc39 = ecSc39;
	}

	public Boolean isOaMandateForPublications() {
		return oaMandateForPublications;
	}

	public void setOaMandateForPublications(final Boolean oaMandateForPublications) {
		this.oaMandateForPublications = oaMandateForPublications;
	}

	public Boolean isOaMandateForDatasets() {
		return oaMandateForDatasets;
	}

	public void setOaMandateForDatasets(final Boolean oaMandateForDatasets) {
		this.oaMandateForDatasets = oaMandateForDatasets;
	}

	public String getFundingpathid() {
		return fundingpathid;
	}

	public void setFundingpathid(final String fundingpathid) {
		this.fundingpathid = fundingpathid;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	public String getOrgLegalname() {
		return orgLegalname;
	}

	public void setOrgLegalname(final String orgLegalname) {
		this.orgLegalname = orgLegalname;
	}

	public String getOrgCountry() {
		return orgCountry;
	}

	public void setOrgCountry(final String orgCountry) {
		this.orgCountry = orgCountry;
	}

	public String getOrgRole() {
		return orgRole;
	}

	public void setOrgRole(final String orgRole) {
		this.orgRole = orgRole;
	}

	public String getFirstname() {
		return firstname;
	}

	public void setFirstname(final String firstname) {
		this.firstname = firstname;
	}

	public String getSecondnames() {
		return secondnames;
	}

	public void setSecondnames(final String secondnames) {
		this.secondnames = secondnames;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(final String email) {
		this.email = email;
	}
}
