/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.datasource;

import eu.dnetlib.openaire.exporter.datasource.ApiException;
import eu.dnetlib.openaire.exporter.model.datasource.BrowseTerm;
import eu.dnetlib.openaire.exporter.model.datasource.DatasourceResponse;
import eu.dnetlib.openaire.exporter.model.datasource.Response;
import eu.dnetlib.openaire.exporter.model.datasource.db.Datasource;
import eu.dnetlib.openaire.exporter.model.datasource.db.SearchInterfacesEntry;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;

@Api(value="datasources", description="the datasource manager API")
public interface DatasourcesApi {
    @ApiOperation(value="list identifiers", notes="List the Datasource identifiers.", response=List.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=String[].class), @ApiResponse(code=500, message="unexpected error", response=Response.class)})
    public List<String> listIds(int var1, int var2) throws ApiException;

    @ApiOperation(value="get datasource by id", notes="Returns Datasource details.", response=DatasourceResponse.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=DatasourceResponse[].class), @ApiResponse(code=500, message="unexpected error", response=Response.class)})
    public DatasourceResponse getDs(String var1);

    @ApiOperation(value="search datasources by name", notes="Returns list of Datasource details.", response=DatasourceResponse[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=DatasourceResponse[].class), @ApiResponse(code=500, message="unexpected error", response=Response.class)})
    public List<DatasourceResponse> searchByName(String var1, int var2, int var3);

    @ApiOperation(value="search datasources by contact email", notes="Returns list of Datasource details.", response=DatasourceResponse[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=DatasourceResponse[].class), @ApiResponse(code=500, message="unexpected error", response=Response.class)})
    public List<DatasourceResponse> searchByContactemail(String var1, int var2, int var3);

    @ApiOperation(value="search datasources by country", notes="Returns list of Datasource details.", response=DatasourceResponse[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=DatasourceResponse[].class), @ApiResponse(code=500, message="unexpected error", response=Response.class)})
    public List<DatasourceResponse> searchByCountry(String var1, int var2, int var3);

    @ApiOperation(value="search among datasource APIs", notes="Returns Datasource Api details.", response=SearchInterfacesEntry[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=SearchInterfacesEntry[].class), @ApiResponse(code=500, message="unexpected error", response=Response.class)})
    public List<SearchInterfacesEntry> searchInterface(String var1, String var2);

    @ApiOperation(value="terms and count for the given field", notes="Returns the list of BrowseTerms.", response=BrowseTerm[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=BrowseTerm[].class), @ApiResponse(code=500, message="unexpected error", response=Response.class)})
    public List<? extends BrowseTerm> browseField(String var1) throws ApiException;

    @ApiOperation(value="get the list of API for a given datasource", notes="Returns the list of API for a given datasource.", httpMethod="GET", response=eu.dnetlib.openaire.exporter.model.datasource.db.Api[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=eu.dnetlib.openaire.exporter.model.datasource.db.Api[].class), @ApiResponse(code=500, message="unexpected error", response=Response.class)})
    public List<eu.dnetlib.openaire.exporter.model.datasource.db.Api> getApi(String var1) throws ApiException;

    @ApiOperation(value="delete an API", notes="delete an API", httpMethod="DELETE")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error")})
    public void deleteApi(String var1) throws ApiException;

    @ApiOperation(value="adds a new API to one Datasource", notes="adds an API to one Datasource", httpMethod="POST")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error")})
    public void addApi(eu.dnetlib.openaire.exporter.model.datasource.db.Api var1) throws ApiException;

    @ApiOperation(value="set the managed status for a given datasource", notes="set the managed status for a given datasource", httpMethod="POST")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error")})
    public void setManaged(String var1, boolean var2);

    @ApiOperation(value="adds a new Datasource", notes="adds a new Datasource", httpMethod="POST")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error")})
    public void saveDatasource(Datasource var1) throws ApiException;

    @ApiOperation(value="updates a datasource official name", notes="updates a datasource official name", httpMethod="POST")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error")})
    public void updateOfficialname(String var1, String var2) throws ApiException;

    @ApiOperation(value="updates a datasource english name", notes="updates a datasource english name", httpMethod="POST")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error")})
    public void updateEnglishname(String var1, String var2) throws ApiException;

    @ApiOperation(value="updates a datasource latitude", notes="updates a datasource latitude", httpMethod="POST")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error")})
    public void updateLatitude(String var1, Double var2) throws ApiException;

    @ApiOperation(value="updates a datasource longitude", notes="updates a datasource longitude", httpMethod="POST")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="unexpected error")})
    public void updateLongitude(String var1, Double var2) throws ApiException;
}

