/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.datasource.clients;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.openaire.exporter.datasource.ApiException;
import eu.dnetlib.openaire.exporter.datasource.clients.ClientResponse;
import eu.dnetlib.openaire.exporter.datasource.clients.DatasourceIndexClient;
import eu.dnetlib.openaire.exporter.datasource.clients.ISLookupClient;
import eu.dnetlib.openaire.exporter.datasource.clients.MongoLoggerClient;
import eu.dnetlib.openaire.exporter.datasource.repository.ActivationTermRepository;
import eu.dnetlib.openaire.exporter.datasource.repository.ApiRepository;
import eu.dnetlib.openaire.exporter.datasource.repository.CompatibilityTermRepository;
import eu.dnetlib.openaire.exporter.datasource.repository.CountryTermRepository;
import eu.dnetlib.openaire.exporter.datasource.repository.DatasourceRepository;
import eu.dnetlib.openaire.exporter.datasource.repository.ProtocolTermRepository;
import eu.dnetlib.openaire.exporter.datasource.repository.SearchInterfaceRepository;
import eu.dnetlib.openaire.exporter.datasource.repository.TypologyTermRepository;
import eu.dnetlib.openaire.exporter.model.datasource.AggregationInfo;
import eu.dnetlib.openaire.exporter.model.datasource.AggregationStage;
import eu.dnetlib.openaire.exporter.model.datasource.DatasourceResponse;
import eu.dnetlib.openaire.exporter.model.datasource.db.ActivationTerm;
import eu.dnetlib.openaire.exporter.model.datasource.db.Api;
import eu.dnetlib.openaire.exporter.model.datasource.db.CompatibilityTerm;
import eu.dnetlib.openaire.exporter.model.datasource.db.CountryTerm;
import eu.dnetlib.openaire.exporter.model.datasource.db.Datasource;
import eu.dnetlib.openaire.exporter.model.datasource.db.ProtocolTerm;
import eu.dnetlib.openaire.exporter.model.datasource.db.SearchInterfacesEntry;
import eu.dnetlib.openaire.exporter.model.datasource.db.TypologyTerm;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

@Component
public class DatasourceDao {
    private static final Log log = LogFactory.getLog(DatasourceDao.class);
    @Autowired
    private OpenaireExporterConfig config;
    @Autowired
    private MongoLoggerClient mongoLoggerClient;
    @Autowired
    private DatasourceIndexClient datasourceIndexClient;
    @Autowired
    private DatasourceRepository dsRepository;
    @Autowired
    private SearchInterfaceRepository searchInterfaceRepository;
    @Autowired
    private CountryTermRepository countryTermRepository;
    @Autowired
    private TypologyTermRepository typologyTermRepository;
    @Autowired
    private ProtocolTermRepository protocolTermRepository;
    @Autowired
    private CompatibilityTermRepository compatibilityTermRepository;
    @Autowired
    private ActivationTermRepository activationTermRepository;
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private ISLookupClient isLookupClient;
    private ListeningExecutorService service;

    @PostConstruct
    public void init() {
        this.service = MoreExecutors.listeningDecorator((ScheduledExecutorService)new ScheduledThreadPoolExecutor(this.config.getRequestWorkers(), new ThreadFactoryBuilder().setNameFormat("datasource-info-retriever-%d").build()));
    }

    public List<String> listIds(Pageable pageable) throws ApiException {
        return this.dsRepository.findAll(pageable).map(d -> d.getId()).getContent();
    }

    public List<DatasourceResponse> searchByName(String name, Pageable pageable) {
        ArrayList datasourceResponse = Lists.newArrayList();
        CountDownLatch outerLatch = new CountDownLatch(3);
        ConcurrentLinkedQueue errors = new ConcurrentLinkedQueue();
        log.debug((Object)String.format("search ds by name '%s'", name));
        ListenableFuture c = this.dsRepository.findByOfficialnameContainingOrEnglishnameContainingAllIgnoreCase(name, name, pageable);
        c.addCallback(this.getSearchCallback(outerLatch, errors, (List)datasourceResponse));
        this.waitLatch(outerLatch, errors, this.config.getRequestTimeout());
        return datasourceResponse;
    }

    public List<DatasourceResponse> searchByCountry(String country, Pageable pageable) {
        ArrayList datasourceResponse = Lists.newArrayList();
        CountDownLatch outerLatch = new CountDownLatch(3);
        ConcurrentLinkedQueue errors = new ConcurrentLinkedQueue();
        log.debug((Object)String.format("search ds by country '%s'", country));
        this.waitLatch(outerLatch, errors, this.config.getRequestTimeout());
        return datasourceResponse;
    }

    public List<DatasourceResponse> searchByContactemail(String email, Pageable pageable) {
        ArrayList datasourceResponse = Lists.newArrayList();
        CountDownLatch outerLatch = new CountDownLatch(3);
        ConcurrentLinkedQueue errors = new ConcurrentLinkedQueue();
        log.debug((Object)String.format("search ds by email '%s'", email));
        this.dsRepository.findByContactemailContainingAllIgnoreCase(email, pageable).addCallback(this.getSearchCallback(outerLatch, errors, (List)datasourceResponse));
        this.waitLatch(outerLatch, errors, this.config.getRequestTimeout());
        return datasourceResponse;
    }

    private ListenableFutureCallback<Slice<Datasource>> getSearchCallback(CountDownLatch outerLatch, Queue<Throwable> errors, List<DatasourceResponse> datasourceResponse) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ClientResponse getInfo(String dsId) {
        CountDownLatch outerLatch = new CountDownLatch(3);
        ConcurrentLinkedQueue errors = new ConcurrentLinkedQueue();
        DatasourceResponse datasourceResponse = new DatasourceResponse();
        this.getAggregationHistory(dsId, outerLatch, errors, datasourceResponse);
        this.dsRepository.findOneById(dsId).addCallback((ListenableFutureCallback)new /* Unavailable Anonymous Inner Class!! */);
        this.getIndexDsInfo(dsId, outerLatch, errors, datasourceResponse);
        this.waitLatch(outerLatch, errors, this.config.getRequestTimeout());
        return new ClientResponse().datasourceInfo(datasourceResponse).errors(errors);
    }

    public void setManaged(String id, boolean managed) {
        log.info((Object)String.format("setting managed = '%s' for ds '%s'", managed, id));
        this.dsRepository.setManaged(id, managed);
    }

    public List<SearchInterfacesEntry> searchInterface(String field, String value) {
        switch (field) {
            case "__SEARCH__": {
                return this.searchInterfaceRepository.findByRepoidContainingOrRepoNameContainingOrAlternativeNameContainingOrRepoPrefixContainingOrRepoOrganizationContainingAllIgnoreCase(value, value, value, value, value);
            }
            case "country": {
                break;
            }
            case "type": {
                break;
            }
            case "protocol": {
                break;
            }
            case "compliance": {
                break;
            }
            case "active": {
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        return null;
    }

    public List<CountryTerm> browseCountries() {
        return this.countryTermRepository.findAll();
    }

    public List<TypologyTerm> browseTypologies() {
        return this.typologyTermRepository.findAll();
    }

    public List<ProtocolTerm> browseProtocols() {
        return this.protocolTermRepository.findAll();
    }

    public List<CompatibilityTerm> browseCompatibility() {
        return this.compatibilityTermRepository.findAll();
    }

    public List<ActivationTerm> browseActivation() {
        return this.activationTermRepository.findAll();
    }

    public List<Api> getApi(String dsId) {
        return this.apiRepository.findByDatasource(dsId);
    }

    public void deleteApi(String apiId) {
        this.apiRepository.delete((Serializable)((Object)apiId));
        log.info((Object)String.format("deleted api '%s'", apiId));
    }

    public void addApi(Api api) {
        if (StringUtils.isBlank((String)api.getId())) {
            api.setId(ApiRepository.createId((Api)api));
            log.info((Object)String.format("missing api id, created '%s'", new Object[0]));
        }
        this.apiRepository.save((Object)api);
    }

    public boolean exist(Datasource d) throws ApiException {
        try {
            return this.dsRepository.findOneById(d.getId()).get() != null;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new ApiException(500, String.format("error retrieving datasource information '%s'", d.getId()), (Throwable)e);
        }
    }

    public Datasource save(Datasource d) {
        log.info((Object)String.format("saving datasource '%s'", d.getId()));
        Datasource datasource = (Datasource)this.dsRepository.save((Object)d);
        log.info((Object)String.format("saved datasource '%s'", datasource.getId()));
        return datasource;
    }

    public void updateOfficialName(String dsId, String officialname) {
        this.dsRepository.setOfficialname(dsId, officialname);
        log.info((Object)String.format("updated datasource '%s' with officialname '%s'", dsId, officialname));
    }

    public void updateEnglishName(String dsId, String englishname) {
        this.dsRepository.setEnglishname(dsId, englishname);
        log.info((Object)String.format("updated datasource '%s' with englishname '%s'", dsId, englishname));
    }

    public void updateLatitude(String dsId, Double latitude) {
        this.dsRepository.setLatitude(dsId, latitude);
        log.info((Object)String.format("updated datasource '%s' with latitude '%s'", dsId, latitude));
    }

    public void updateLongitude(String dsId, Double longitude) {
        this.dsRepository.setLongitude(dsId, longitude);
        log.info((Object)String.format("updated datasource '%s' with longitude '%s'", dsId, longitude));
    }

    private void getIndexDsInfo(String dsId, CountDownLatch outerLatch, Queue<Throwable> errors, DatasourceResponse datasourceResponse) {
        Futures.addCallback((com.google.common.util.concurrent.ListenableFuture)this.service.submit(() -> this.isLookupClient.calculateCurrentIndexDsInfo()), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void getAggregationHistory(String dsId, CountDownLatch outerLatch, Queue<Throwable> errors, DatasourceResponse datasourceResponse) {
        Futures.addCallback((com.google.common.util.concurrent.ListenableFuture)this.service.submit(() -> this.mongoLoggerClient.getAggregationHistory(dsId)), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setAggregationHistory(DatasourceResponse datasourceResponse, List<AggregationInfo> info) {
        datasourceResponse.setAggregationHistory(info);
        if (!info.isEmpty()) {
            datasourceResponse.setLastCollection(info.stream().filter(a -> AggregationStage.COLLECT.equals((Object)a.getAggregationStage())).findFirst().get()).setLastTransformation(info.stream().filter(a -> AggregationStage.TRANSFORM.equals((Object)a.getAggregationStage())).findFirst().get());
        }
    }

    private void waitLatch(CountDownLatch latch, Queue<Throwable> errors, int waitSeconds) {
        try {
            if (!latch.await(waitSeconds, TimeUnit.SECONDS)) {
                errors.offer(new TimeoutException("Waiting for requests to complete has timed out."));
            }
        }
        catch (InterruptedException e) {
            errors.offer(e);
        }
    }

    static /* synthetic */ void access$000(DatasourceDao x0, String x1, CountDownLatch x2, Queue x3, DatasourceResponse x4) {
        x0.getAggregationHistory(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$100(DatasourceDao x0, String x1, CountDownLatch x2, Queue x3, DatasourceResponse x4) {
        x0.getIndexDsInfo(x1, x2, x3, x4);
    }

    static /* synthetic */ Log access$200() {
        return log;
    }

    static /* synthetic */ ListeningExecutorService access$300(DatasourceDao x0) {
        return x0.service;
    }

    static /* synthetic */ OpenaireExporterConfig access$400(DatasourceDao x0) {
        return x0.config;
    }

    static /* synthetic */ void access$500(DatasourceDao x0, CountDownLatch x1, Queue x2, int x3) {
        x0.waitLatch(x1, x2, x3);
    }

    static /* synthetic */ DatasourceIndexClient access$600(DatasourceDao x0) {
        return x0.datasourceIndexClient;
    }

    static /* synthetic */ void access$700(DatasourceDao x0, DatasourceResponse x1, List x2) {
        x0.setAggregationHistory(x1, x2);
    }
}

