/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.datasource.clients;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.Utils;
import eu.dnetlib.openaire.exporter.datasource.ApiException;
import eu.dnetlib.openaire.exporter.model.datasource.AggregationInfo;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MongoLoggerClient {
    private static final Log log = LogFactory.getLog(MongoLoggerClient.class);
    @Autowired
    private MongoClient datasourcePublisherMongoClient;
    @Autowired
    private OpenaireExporterConfig config;
    private static Bson fields = MongoLoggerClient.getFields();
    private static MongoCollection<Document> collection = null;

    private Bson getQuery(String dsId) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"parentDatasourceId", (Object)dsId), Filters.eq((String)"system:profileFamily", (Object)"aggregator"), Filters.eq((String)"system:isCompletedSuccessfully", (Object)"true"), Filters.regex((String)"system:wfName", (String)"(collect|transform)", (String)"i")});
    }

    private synchronized MongoCollection<Document> getCollection() {
        if (collection == null) {
            log.info((Object)"inizializing mongodb collection ...");
            OpenaireExporterConfig.Datasource conf = this.config.getDatasource();
            collection = this.datasourcePublisherMongoClient.getDatabase(conf.getMongoDbName()).getCollection(conf.getMongoCollectionName());
        }
        return collection;
    }

    @Cacheable(value={"datasources-mongo-cache"})
    public List<AggregationInfo> getAggregationHistory(String dsId) throws ApiException {
        log.warn((Object)String.format("getAggregationHistory(dsId = %s): not using cache", dsId));
        OpenaireExporterConfig.Datasource conf = this.config.getDatasource();
        Bson query = this.getQuery(dsId);
        return Utils.stream((Iterator)this.getCollection().find(query).projection(fields).limit(conf.getMongoQueryLimit()).sort((Bson)MongoLoggerClient.dbo((String)"system:startHumanDate", (Object)-1)).iterator()).map(this.getMapper()).filter(ai -> ai.getNumberOfRecords() >= 0 && StringUtils.isNotBlank((String)ai.getDate())).collect(Collectors.toList());
    }

    private Function<Document, AggregationInfo> getMapper() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static Bson getFields() {
        return Projections.fields((Bson[])new Bson[]{Filters.eq((String)"system:wfName", (Object)1), Filters.eq((String)"system:node:SELECT_MODE:selection", (Object)1), Filters.eq((String)"mainlog:sinkSize", (Object)1), Filters.eq((String)"mainlog:writeOps", (Object)1), Filters.eq((String)"mainlog:total", (Object)1), Filters.eq((String)"system:startHumanDate", (Object)1), Filters.eq((String)"system:profileName", (Object)1)});
    }

    private static BasicDBObject dbo(String key, Object value) {
        return new BasicDBObject(key, value);
    }
}

