package eu.dnetlib.openaire.exporter.model.datasource.db;

import java.sql.Date;
import java.util.Set;

import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;

/**
 * Created by claudio on 13/04/2017.
 */
@Entity
@Table(name = "dsm_organizations")
//@JsonAutoDetect
@ApiModel(value = "Organization model", description = "provides organization details")
public class Organization {

	@Id
	private String id;
	private String legalshortname;
	private String legalname;
	private String websiteurl;
	private String logourl;

	@Column(name = "ec_legalbody")
	private Boolean eclegalbody;

	@Column(name = "ec_legalperson")
	private Boolean eclegalperson;

	@Column(name = "ec_nonprofit")
	private Boolean ecnonprofit;

	@Column(name = "ec_researchorganization")
	private Boolean ecresearchorganization;

	@Column(name = "ec_highereducation")
	private Boolean echighereducation;

	@Column(name = "ec_internationalorganizationeurinterests")
	private Boolean ecinternationalorganizationeurinterests;

	@Column(name = "ec_internationalorganization")
	private Boolean ecinternationalorganization;

	@Column(name = "ec_enterprise")
	private Boolean ecenterprise;

	@Column(name = "ec_smevalidated")
	private Boolean ecsmevalidated;

	@Column(name = "ec_nutscode")
	private Boolean ecnutscode;

	private String country;
	private String collectedfrom;

	private Date dateofcollection;
	private String provenanceaction;

	@JsonIgnore
	@ManyToMany(
			cascade = { CascadeType.PERSIST, CascadeType.MERGE },
			fetch = FetchType.EAGER,
			mappedBy = "organizations")
	private Set<Datasource> datasources;

	public Organization() {}

	public String getId() {
		return id;
	}

	public String getLegalshortname() {
		return legalshortname;
	}

	public String getLegalname() {
		return legalname;
	}

	public String getWebsiteurl() {
		return websiteurl;
	}

	public String getLogourl() {
		return logourl;
	}

	public Boolean isEclegalbody() {
		return eclegalbody;
	}

	public Boolean isEclegalperson() {
		return eclegalperson;
	}

	public Boolean isEcnonprofit() {
		return ecnonprofit;
	}

	public Boolean isEcresearchorganization() {
		return ecresearchorganization;
	}

	public Boolean isEchighereducation() {
		return echighereducation;
	}

	public Boolean isEcinternationalorganizationeurinterests() {
		return ecinternationalorganizationeurinterests;
	}

	public Boolean isEcinternationalorganization() {
		return ecinternationalorganization;
	}

	public Boolean isEcenterprise() {
		return ecenterprise;
	}

	public Boolean isEcsmevalidated() {
		return ecsmevalidated;
	}

	public Boolean isEcnutscode() {
		return ecnutscode;
	}

	public String getCountry() {
		return country;
	}

	public String getCollectedfrom() {
		return collectedfrom;
	}

	public Date getDateofcollection() {
		return dateofcollection;
	}

	public String getProvenanceaction() {
		return provenanceaction;
	}

	public Organization setId(final String id) {
		this.id = id;
		return this;
	}

	public Organization setLegalshortname(final String legalshortname) {
		this.legalshortname = legalshortname;
		return this;
	}

	public Organization setLegalname(final String legalname) {
		this.legalname = legalname;
		return this;
	}

	public Organization setWebsiteurl(final String websiteurl) {
		this.websiteurl = websiteurl;
		return this;
	}

	public Organization setLogourl(final String logourl) {
		this.logourl = logourl;
		return this;
	}

	public Organization setEclegalbody(final Boolean eclegalbody) {
		this.eclegalbody = eclegalbody;
		return this;
	}

	public Organization setEclegalperson(final Boolean eclegalperson) {
		this.eclegalperson = eclegalperson;
		return this;
	}

	public Organization setEcnonprofit(final Boolean ecnonprofit) {
		this.ecnonprofit = ecnonprofit;
		return this;
	}

	public Organization setEcresearchorganization(final Boolean ecresearchorganization) {
		this.ecresearchorganization = ecresearchorganization;
		return this;
	}

	public Organization setEchighereducation(final Boolean echighereducation) {
		this.echighereducation = echighereducation;
		return this;
	}

	public Organization setEcinternationalorganizationeurinterests(final Boolean ecinternationalorganizationeurinterests) {
		this.ecinternationalorganizationeurinterests = ecinternationalorganizationeurinterests;
		return this;
	}

	public Organization setEcinternationalorganization(final Boolean ecinternationalorganization) {
		this.ecinternationalorganization = ecinternationalorganization;
		return this;
	}

	public Organization setEcenterprise(final Boolean ecenterprise) {
		this.ecenterprise = ecenterprise;
		return this;
	}

	public Organization setEcsmevalidated(final Boolean ecsmevalidated) {
		this.ecsmevalidated = ecsmevalidated;
		return this;
	}

	public Organization setEcnutscode(final Boolean ecnutscode) {
		this.ecnutscode = ecnutscode;
		return this;
	}

	public Organization setCountry(final String country) {
		this.country = country;
		return this;
	}

	public Organization setCollectedfrom(final String collectedfrom) {
		this.collectedfrom = collectedfrom;
		return this;
	}

	public Organization setDateofcollection(final Date dateofcollection) {
		this.dateofcollection = dateofcollection;
		return this;
	}

	public Organization setProvenanceaction(final String provenanceaction) {
		this.provenanceaction = provenanceaction;
		return this;
	}

	public Set<Datasource> getDatasources() {
		return datasources;
	}

	public void setDatasources(final Set<Datasource> datasources) {
		this.datasources = datasources;
	}

}
