package eu.dnetlib.openaire.exporter.model.datasource.db;

import java.sql.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModel;

/**
 * Created by claudio on 13/04/2017.
 */
@Entity
@Table(name = "search_api")
@ApiModel
@JsonAutoDetect
public class SearchInterfacesEntry implements Comparable<SearchInterfacesEntry> {

	@Id
	private String id;

	@Column(name = "compatibility")
	private String compliance;

	@Column(name = "protocol")
	private String protocol;

	@Column(name = "active")
	private boolean active;

	@Column(name = "repoid")
	private String repoid = "unknown";

	@Column(name = "officialname")
	private String repoName = "unknown";

	@Column(name = "englishname")
	private String alternativeName = "unknown";

	@Column(name = "country")
	private String repoCountry = "-";

	@Column(name = "organization")
	private String repoOrganization = "-";

	@Column(name = "namespaceprefix", columnDefinition = "bpchar(12)")
	private String repoPrefix = "";

	@Column(name = "last_aggregation_date")
	private Date aggrDate;

	@Column(name = "last_aggregation_total")
	private Integer aggrTotal = 0;

	public SearchInterfacesEntry() {}

	@Override
	public int compareTo(final SearchInterfacesEntry e) {
		return compliance.compareTo(e.getCompliance());
	}

	public String getId() {
		return id;
	}

	public String getCompliance() {
		return compliance;
	}

	public String getProtocol() {
		return protocol;
	}

	public boolean isActive() {
		return active;
	}

	public String getRepoid() {
		return repoid;
	}

	public String getRepoName() {
		return repoName;
	}

	public String getAlternativeName() {
		return alternativeName;
	}

	public String getRepoCountry() {
		return repoCountry;
	}

	public String getRepoOrganization() {
		return repoOrganization;
	}

	public String getRepoPrefix() {
		return repoPrefix;
	}

	public Date getAggrDate() {
		return aggrDate;
	}

	public Integer getAggrTotal() {
		return aggrTotal;
	}

	public SearchInterfacesEntry setId(final String id) {
		this.id = id;
		return this;
	}

	public SearchInterfacesEntry setCompliance(final String compliance) {
		this.compliance = compliance;
		return this;
	}

	public SearchInterfacesEntry setProtocol(final String protocol) {
		this.protocol = protocol;
		return this;
	}

	public SearchInterfacesEntry setActive(final boolean active) {
		this.active = active;
		return this;
	}

	public SearchInterfacesEntry setRepoid(final String repoid) {
		this.repoid = repoid;
		return this;
	}

	public SearchInterfacesEntry setRepoName(final String repoName) {
		this.repoName = repoName;
		return this;
	}

	public SearchInterfacesEntry setAlternativeName(final String alternativeName) {
		this.alternativeName = alternativeName;
		return this;
	}

	public SearchInterfacesEntry setRepoCountry(final String repoCountry) {
		this.repoCountry = repoCountry;
		return this;
	}

	public SearchInterfacesEntry setRepoOrganization(final String repoOrganization) {
		this.repoOrganization = repoOrganization;
		return this;
	}

	public SearchInterfacesEntry setRepoPrefix(final String repoPrefix) {
		this.repoPrefix = repoPrefix;
		return this;
	}

	public SearchInterfacesEntry setAggrDate(final Date aggrDate) {
		this.aggrDate = aggrDate;
		return this;
	}

	public SearchInterfacesEntry setAggrTotal(final Integer aggrTotal) {
		this.aggrTotal = aggrTotal;
		return this;
	}

}
