/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.model.datasource.db;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModel;
import java.sql.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="search_api")
@ApiModel
@JsonAutoDetect
public class SearchInterfacesEntry
implements Comparable<SearchInterfacesEntry> {
    @Id
    private String id;
    @Column(name="compatibility")
    private String compliance;
    @Column(name="protocol")
    private String protocol;
    @Column(name="active")
    private boolean active;
    @Column(name="repoid")
    private String repoid = "unknown";
    @Column(name="officialname")
    private String repoName = "unknown";
    @Column(name="englishname")
    private String alternativeName = "unknown";
    @Column(name="country")
    private String repoCountry = "-";
    @Column(name="organization")
    private String repoOrganization = "-";
    @Column(name="namespaceprefix", columnDefinition="bpchar(12)")
    private String repoPrefix = "";
    @Column(name="last_aggregation_date")
    private Date aggrDate;
    @Column(name="last_aggregation_total")
    private Integer aggrTotal = 0;

    @Override
    public int compareTo(SearchInterfacesEntry e) {
        return this.compliance.compareTo(e.getCompliance());
    }

    public String getId() {
        return this.id;
    }

    public String getCompliance() {
        return this.compliance;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getRepoid() {
        return this.repoid;
    }

    public String getRepoName() {
        return this.repoName;
    }

    public String getAlternativeName() {
        return this.alternativeName;
    }

    public String getRepoCountry() {
        return this.repoCountry;
    }

    public String getRepoOrganization() {
        return this.repoOrganization;
    }

    public String getRepoPrefix() {
        return this.repoPrefix;
    }

    public Date getAggrDate() {
        return this.aggrDate;
    }

    public Integer getAggrTotal() {
        return this.aggrTotal;
    }

    public SearchInterfacesEntry setId(String id) {
        this.id = id;
        return this;
    }

    public SearchInterfacesEntry setCompliance(String compliance) {
        this.compliance = compliance;
        return this;
    }

    public SearchInterfacesEntry setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public SearchInterfacesEntry setActive(boolean active) {
        this.active = active;
        return this;
    }

    public SearchInterfacesEntry setRepoid(String repoid) {
        this.repoid = repoid;
        return this;
    }

    public SearchInterfacesEntry setRepoName(String repoName) {
        this.repoName = repoName;
        return this;
    }

    public SearchInterfacesEntry setAlternativeName(String alternativeName) {
        this.alternativeName = alternativeName;
        return this;
    }

    public SearchInterfacesEntry setRepoCountry(String repoCountry) {
        this.repoCountry = repoCountry;
        return this;
    }

    public SearchInterfacesEntry setRepoOrganization(String repoOrganization) {
        this.repoOrganization = repoOrganization;
        return this;
    }

    public SearchInterfacesEntry setRepoPrefix(String repoPrefix) {
        this.repoPrefix = repoPrefix;
        return this;
    }

    public SearchInterfacesEntry setAggrDate(Date aggrDate) {
        this.aggrDate = aggrDate;
        return this;
    }

    public SearchInterfacesEntry setAggrTotal(Integer aggrTotal) {
        this.aggrTotal = aggrTotal;
        return this;
    }
}

