package eu.dnetlib;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@EnableCaching
@RestController
@SpringBootApplication
public class DNetOpenaireExporterApplication {

	private static final Log log = LogFactory.getLog(DNetOpenaireExporterApplication.class);

	@Autowired
	private List<RequestMappingHandlerMapping> handlerMappings;

	@RequestMapping(value = { "/", "/docs" })
	public void index(final HttpServletResponse response) throws IOException {
		response.sendRedirect("swagger-ui.html");
	}

	@RequestMapping(value = "/endpointdoc", method = RequestMethod.GET)
	public Set<String> show() {
		return handlerMappings.stream()
				.map(handler -> handler.getHandlerMethods().keySet())
				.map(rmInfo -> rmInfo.toString())
				.collect(Collectors.toSet());
	}

	public static void main(String[] args) throws Exception {
		SpringApplication.run(DNetOpenaireExporterApplication.class, args);
	}

}
