package eu.dnetlib.openaire.exporter.model.datasource;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModel;

/**
 * Created by claudio on 24/11/2016.
 */
@ApiModel
@JsonAutoDetect
public class Header {

	private long queryTime;

	private String datasourceId;

	private int statusCode;

	private String error = "";

	public Header() {
	}

	public Header setQueryTime(final long queryTime) {
		this.queryTime = queryTime;
		return this;
	}

	public Header setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
		return this;
	}

	public Header setError(final String error) {
		this.error = error;
		return this;
	}

	public long getQueryTime() {
		return queryTime;
	}

	public String getDatasourceId() {
		return datasourceId;
	}

	public String getError() {
		return error;
	}

	public int getStatusCode() {
		return statusCode;
	}

	public Header setStatusCode(final int statusCode) {
		this.statusCode = statusCode;
		return this;
	}
}
