package eu.dnetlib.openaire.exporter.model.datasource.db;

import java.sql.Date;
import java.util.Objects;
import java.util.Set;

import javax.persistence.*;

import com.google.common.collect.ComparisonChain;
import com.google.gson.Gson;
import io.swagger.annotations.ApiModel;

/**
 * Api
 */
@Entity
@Table(name = "dsm_api")
@ApiModel(value = "Datasource Api model", description = "describes the datasource api")
public class Api implements Comparable<Api> {

	@Id
	private String id = null;

	private String protocol = null;

	private String datasource = null;
	private String contentdescription = null;
	private Boolean active = false;
	private Boolean removable = false;
	private String typology = null;

	private String compatibility;

	@Column(name = "metadata_identifier_path")
	private String metadataIdentifierPath;

	@Column(name = "last_collection_total")
	private Integer lastCollectionTotal;
	@Column(name = "last_collection_date")
	private Date lastCollectionDate;
	@Column(name = "last_collection_mdid")
	private String lastCollectionMdid;

	@Column(name = "last_aggregation_total")
	private Integer lastAggregationTotal;
	@Column(name = "last_aggregation_date")
	private Date lastAggregationDate;
	@Column(name = "last_aggregation_mdid")
	private String lastAggregationMdid;

	@Column(name = "last_download_total")
	private Integer lastDownloadTotal;
	@Column(name = "last_download_date")
	private Date lastDownloadDate;
	@Column(name = "last_download_objid")
	private String lastDownloadMdid;

	@Column(name = "last_validation_job")
	private String lastValidationJob;

	private String baseurl = null;

	@OneToMany(mappedBy = "id.api", cascade = CascadeType.ALL, fetch = FetchType.EAGER)
	private Set<Apiparam> apiparam;

	public Api() {}

	public String getId() {
		return id;
	}

	public String getProtocol() {
		return protocol;
	}

	public String getDatasource() {
		return datasource;
	}

	public String getContentdescription() {
		return contentdescription;
	}

	public Boolean getActive() {
		return active;
	}

	public Boolean getRemovable() {
		return removable;
	}

	public String getTypology() {
		return typology;
	}

	public String getCompatibility() {
		return compatibility;
	}

	public String getMetadataIdentifierPath() {
		return metadataIdentifierPath;
	}

	public Integer getLastCollectionTotal() {
		return lastCollectionTotal;
	}

	public Date getLastCollectionDate() {
		return lastCollectionDate;
	}

	public String getLastCollectionMdid() {
		return lastCollectionMdid;
	}

	public Integer getLastAggregationTotal() {
		return lastAggregationTotal;
	}

	public Date getLastAggregationDate() {
		return lastAggregationDate;
	}

	public String getLastAggregationMdid() {
		return lastAggregationMdid;
	}

	public Integer getLastDownloadTotal() {
		return lastDownloadTotal;
	}

	public Date getLastDownloadDate() {
		return lastDownloadDate;
	}

	public String getLastDownloadMdid() {
		return lastDownloadMdid;
	}

	public String getLastValidationJob() {
		return lastValidationJob;
	}

	public String getBaseurl() {
		return baseurl;
	}

	public Set<Apiparam> getApiparam() {
		return apiparam;
	}

	public Api setId(final String id) {
		this.id = id;
		return this;
	}

	public Api setProtocol(final String protocol) {
		this.protocol = protocol;
		return this;
	}

	public Api setDatasource(final String datasource) {
		this.datasource = datasource;
		return this;
	}

	public Api setContentdescription(final String contentdescription) {
		this.contentdescription = contentdescription;
		return this;
	}

	public Api setActive(final Boolean active) {
		this.active = active;
		return this;
	}

	public Api setRemovable(final Boolean removable) {
		this.removable = removable;
		return this;
	}

	public Api setTypology(final String typology) {
		this.typology = typology;
		return this;
	}

	public Api setCompatibility(final String compatibility) {
		this.compatibility = compatibility;
		return this;
	}

	public Api setMetadataIdentifierPath(final String metadataIdentifierPath) {
		this.metadataIdentifierPath = metadataIdentifierPath;
		return this;
	}

	public Api setLastCollectionTotal(final Integer lastCollectionTotal) {
		this.lastCollectionTotal = lastCollectionTotal;
		return this;
	}

	public Api setLastCollectionDate(final Date lastCollectionDate) {
		this.lastCollectionDate = lastCollectionDate;
		return this;
	}

	public Api setLastCollectionMdid(final String lastCollectionMdid) {
		this.lastCollectionMdid = lastCollectionMdid;
		return this;
	}

	public Api setLastAggregationTotal(final Integer lastAggregationTotal) {
		this.lastAggregationTotal = lastAggregationTotal;
		return this;
	}

	public Api setLastAggregationDate(final Date lastAggregationDate) {
		this.lastAggregationDate = lastAggregationDate;
		return this;
	}

	public Api setLastAggregationMdid(final String lastAggregationMdid) {
		this.lastAggregationMdid = lastAggregationMdid;
		return this;
	}

	public Api setLastDownloadTotal(final Integer lastDownloadTotal) {
		this.lastDownloadTotal = lastDownloadTotal;
		return this;
	}

	public Api setLastDownloadDate(final Date lastDownloadDate) {
		this.lastDownloadDate = lastDownloadDate;
		return this;
	}

	public Api setLastDownloadMdid(final String lastDownloadMdid) {
		this.lastDownloadMdid = lastDownloadMdid;
		return this;
	}

	public Api setLastValidationJob(final String lastValidationJob) {
		this.lastValidationJob = lastValidationJob;
		return this;
	}

	public Api setBaseurl(final String baseurl) {
		this.baseurl = baseurl;
		return this;
	}

	public Api setApiparam(final Set<Apiparam> apiparam) {
		this.apiparam = apiparam;
		return this;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		Api api = (Api) o;
		return Objects.equals(this.id, api.id);
	}

	@Override
	public int hashCode() {
		return Objects.hash(id);
	}

	@Override
	public String toString() {
		return new Gson().toJson(this);
	}

	@Override
	public int compareTo(final Api a) {
		return ComparisonChain.start()
				.compare(getId(), a.getId())
				.result();
	}

}

