package eu.dnetlib.openaire.exporter.model.datasource.db;

import java.io.Serializable;
import java.util.Objects;
import javax.persistence.Embeddable;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.ComparisonChain;

/**
 * Created by claudio on 13/04/2017.
 */
@Embeddable
@JsonIgnoreProperties(ignoreUnknown = true)
public class ApiParamKey implements Serializable {

	@JsonIgnore
	@ManyToOne
	@JoinColumn(name = "api")
	private Api api = null;

	private String param;

	public ApiParamKey() {}

	public String getParam() {
		return param;
	}

	public ApiParamKey setParam(final String param) {
		this.param = param;
		return this;
	}

	public Api getApi() {
		return api;
	}

	public void setApi(final Api api) {
		this.api = api;
	}

	@Override
	public int hashCode() {
		return Objects.hash(getParam(), getApi().getId());
	}

	@Override
	public boolean equals(final Object o) {
		if (this == o) {
			return true;
		}
		if (o == null || getClass() != o.getClass()) {
			return false;
		}
		ApiParamKey apk = (ApiParamKey) o;
		return ComparisonChain.start()
				.compare(getParam(), apk.getParam())
				.compare(getApi(), apk.getApi())
				.result() == 0;
	}


}
