package eu.dnetlib.openaire.exporter.model.datasource.db;

import java.sql.Date;
import java.util.Set;

import javax.persistence.*;

import io.swagger.annotations.ApiModel;

/**
 * Datasource
 */
@Entity
@Table(name = "dsm_datasources")
@ApiModel(value = "Datasource model", description = "provides datasource details")
public class Datasource {

	@Id
	private String id = null;
	private String officialname = null;
	private String englishname = null;
	private String websiteurl = null;
	private String logourl = null;
	private String contactemail = null;
	private Double latitude;
	private Double longitude;
	private String timezone = null;

	@Column(name = "namespaceprefix", columnDefinition = "bpchar(12)")
	private String namespaceprefix;

	private String languages;

	private String od_contenttypes;
	private String collectedfrom = null;
	private Date dateofvalidation = null;
	private String typology = null;
	private String provenanceaction;
	private Date dateofcollection;
	private String platform;

	@Column(name = "activationid")
	private String activationId;
	private String description = null;

	private Date releasestartdate;
	private Date releaseenddate;
	private String missionstatementurl;
	private Boolean dataprovider;
	private Boolean serviceprovider;

	private String databaseaccesstype;
	private String datauploadtype;
	private String databaseaccessrestriction;
	private String datauploadrestriction;

	private Boolean versioning;
	private String citationguidelineurl;
	private String qualitymanagementkind;
	private String pidsystems;

	private String certificates;
	private String aggregator;

	private String issn = null;
	private String eissn = null;
	private String lissn = null;

	private String registeredby = null;

	private String subjects;

	private Boolean managed;

	/*
	@JsonIgnore
	@OneToMany(mappedBy = "datasource", cascade = CascadeType.ALL, fetch = FetchType.EAGER)
	private Set<Api> api = null;
	*/

	@ManyToMany(cascade = { CascadeType.PERSIST, CascadeType.MERGE }, fetch = FetchType.EAGER)
	@JoinTable(
			name = "dsm_datasource_organization",
			joinColumns = @JoinColumn(name="datasource"),
			inverseJoinColumns = @JoinColumn(name="organization"))
	private Set<Organization> organizations;

	@ManyToMany(
			cascade = { CascadeType.PERSIST, CascadeType.MERGE },
	        fetch = FetchType.EAGER )
	@JoinTable(
			name = "dsm_datasourcepids",
			joinColumns = @JoinColumn(name = "datasource"),
			inverseJoinColumns = @JoinColumn(name="pid"))
	private Set<Identity> identities;

	public Datasource() {}

	public String getId() {
		return id;
	}

	public String getOfficialname() {
		return officialname;
	}

	public String getEnglishname() {
		return englishname;
	}

	public String getWebsiteurl() {
		return websiteurl;
	}

	public String getLogourl() {
		return logourl;
	}

	public String getContactemail() {
		return contactemail;
	}

	public Double getLatitude() {
		return latitude;
	}

	public Double getLongitude() {
		return longitude;
	}

	public String getTimezone() {
		return timezone;
	}

	public String getNamespaceprefix() {
		return namespaceprefix;
	}

	public String getLanguages() {
		return languages;
	}

	public String getOd_contenttypes() {
		return od_contenttypes;
	}

	public String getCollectedfrom() {
		return collectedfrom;
	}

	public Date getDateofvalidation() {
		return dateofvalidation;
	}

	public String getTypology() {
		return typology;
	}

	public String getProvenanceaction() {
		return provenanceaction;
	}

	public Date getDateofcollection() {
		return dateofcollection;
	}

	public String getPlatform() {
		return platform;
	}

	public String getActivationId() {
		return activationId;
	}

	public String getDescription() {
		return description;
	}

	public Date getReleasestartdate() {
		return releasestartdate;
	}

	public Date getReleaseenddate() {
		return releaseenddate;
	}

	public String getMissionstatementurl() {
		return missionstatementurl;
	}

	public Boolean isDataprovider() {
		return dataprovider;
	}

	public Boolean isServiceprovider() {
		return serviceprovider;
	}

	public String getDatabaseaccesstype() {
		return databaseaccesstype;
	}

	public String getDatauploadtype() {
		return datauploadtype;
	}

	public String getDatabaseaccessrestriction() {
		return databaseaccessrestriction;
	}

	public String getDatauploadrestriction() {
		return datauploadrestriction;
	}

	public Boolean isVersioning() {
		return versioning;
	}

	public String getCitationguidelineurl() {
		return citationguidelineurl;
	}

	public String getQualitymanagementkind() {
		return qualitymanagementkind;
	}

	public String getPidsystems() {
		return pidsystems;
	}

	public String getCertificates() {
		return certificates;
	}

	public String getAggregator() {
		return aggregator;
	}

	public String getIssn() {
		return issn;
	}

	public String getEissn() {
		return eissn;
	}

	public String getLissn() {
		return lissn;
	}

	public String getRegisteredby() {
		return registeredby;
	}

	public String getSubjects() {
		return subjects;
	}

	public Boolean isManaged() {
		return managed;
	}

	public Set<Organization> getOrganizations() {
		return organizations;
	}

	public Set<Identity> getIdentities() {
		return identities;
	}

	public Datasource setId(final String id) {
		this.id = id;
		return this;
	}

	public Datasource setOfficialname(final String officialname) {
		this.officialname = officialname;
		return this;
	}

	public Datasource setEnglishname(final String englishname) {
		this.englishname = englishname;
		return this;
	}

	public Datasource setWebsiteurl(final String websiteurl) {
		this.websiteurl = websiteurl;
		return this;
	}

	public Datasource setLogourl(final String logourl) {
		this.logourl = logourl;
		return this;
	}

	public Datasource setContactemail(final String contactemail) {
		this.contactemail = contactemail;
		return this;
	}

	public Datasource setLatitude(final Double latitude) {
		this.latitude = latitude;
		return this;
	}

	public Datasource setLongitude(final Double longitude) {
		this.longitude = longitude;
		return this;
	}

	public Datasource setTimezone(final String timezone) {
		this.timezone = timezone;
		return this;
	}

	public Datasource setNamespaceprefix(final String namespaceprefix) {
		this.namespaceprefix = namespaceprefix;
		return this;
	}

	public Datasource setLanguages(final String languages) {
		this.languages = languages;
		return this;
	}

	public Datasource setOd_contenttypes(final String od_contenttypes) {
		this.od_contenttypes = od_contenttypes;
		return this;
	}

	public Datasource setCollectedfrom(final String collectedfrom) {
		this.collectedfrom = collectedfrom;
		return this;
	}

	public Datasource setDateofvalidation(final Date dateofvalidation) {
		this.dateofvalidation = dateofvalidation;
		return this;
	}

	public Datasource setTypology(final String typology) {
		this.typology = typology;
		return this;
	}

	public Datasource setProvenanceaction(final String provenanceaction) {
		this.provenanceaction = provenanceaction;
		return this;
	}

	public Datasource setDateofcollection(final Date dateofcollection) {
		this.dateofcollection = dateofcollection;
		return this;
	}

	public Datasource setPlatform(final String platform) {
		this.platform = platform;
		return this;
	}

	public Datasource setActivationId(final String activationId) {
		this.activationId = activationId;
		return this;
	}

	public Datasource setDescription(final String description) {
		this.description = description;
		return this;
	}

	public Datasource setReleasestartdate(final Date releasestartdate) {
		this.releasestartdate = releasestartdate;
		return this;
	}

	public Datasource setReleaseenddate(final Date releaseenddate) {
		this.releaseenddate = releaseenddate;
		return this;
	}

	public Datasource setMissionstatementurl(final String missionstatementurl) {
		this.missionstatementurl = missionstatementurl;
		return this;
	}

	public Datasource setDataprovider(final Boolean dataprovider) {
		this.dataprovider = dataprovider;
		return this;
	}

	public Datasource setServiceprovider(final Boolean serviceprovider) {
		this.serviceprovider = serviceprovider;
		return this;
	}

	public Datasource setDatabaseaccesstype(final String databaseaccesstype) {
		this.databaseaccesstype = databaseaccesstype;
		return this;
	}

	public Datasource setDatauploadtype(final String datauploadtype) {
		this.datauploadtype = datauploadtype;
		return this;
	}

	public Datasource setDatabaseaccessrestriction(final String databaseaccessrestriction) {
		this.databaseaccessrestriction = databaseaccessrestriction;
		return this;
	}

	public Datasource setDatauploadrestriction(final String datauploadrestriction) {
		this.datauploadrestriction = datauploadrestriction;
		return this;
	}

	public Datasource setVersioning(final Boolean versioning) {
		this.versioning = versioning;
		return this;
	}

	public Datasource setCitationguidelineurl(final String citationguidelineurl) {
		this.citationguidelineurl = citationguidelineurl;
		return this;
	}

	public Datasource setQualitymanagementkind(final String qualitymanagementkind) {
		this.qualitymanagementkind = qualitymanagementkind;
		return this;
	}

	public Datasource setPidsystems(final String pidsystems) {
		this.pidsystems = pidsystems;
		return this;
	}

	public Datasource setCertificates(final String certificates) {
		this.certificates = certificates;
		return this;
	}

	public Datasource setAggregator(final String aggregator) {
		this.aggregator = aggregator;
		return this;
	}

	public Datasource setIssn(final String issn) {
		this.issn = issn;
		return this;
	}

	public Datasource setEissn(final String eissn) {
		this.eissn = eissn;
		return this;
	}

	public Datasource setLissn(final String lissn) {
		this.lissn = lissn;
		return this;
	}

	public Datasource setRegisteredby(final String registeredby) {
		this.registeredby = registeredby;
		return this;
	}

	public Datasource setSubjects(final String subjects) {
		this.subjects = subjects;
		return this;
	}

	public Datasource setManaged(final Boolean managed) {
		this.managed = managed;
		return this;
	}

	public Datasource setOrganizations(final Set<Organization> organizations) {
		this.organizations = organizations;
		return this;
	}

	public Datasource setIdentities(final Set<Identity> identities) {
		this.identities = identities;
		return this;
	}

}

