/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.datasource.clients;

import com.google.common.collect.Iterables;
import eu.dnetlib.data.index.CloudIndexClient;
import eu.dnetlib.data.index.CloudIndexClientException;
import eu.dnetlib.data.index.CloudIndexClientFactory;
import eu.dnetlib.miscutils.functional.hash.Hashing;
import eu.dnetlib.openaire.exporter.datasource.ApiException;
import eu.dnetlib.openaire.exporter.datasource.clients.utils.IndexDsInfo;
import eu.dnetlib.openaire.exporter.datasource.clients.utils.IndexRecordsInfo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class DatasourceIndexClient {
    private static final Log log = LogFactory.getLog(DatasourceIndexClient.class);
    public static final String SEPARATOR = "::";
    public static final String DSVERSION = "__dsversion";
    private static Map<String, CloudIndexClient> indexClientMap = new ConcurrentHashMap();

    public IndexRecordsInfo getIndexInfo(String dsId, IndexDsInfo info) throws ApiException {
        try {
            String collectedFrom = StringUtils.substringBefore((String)dsId, (String)SEPARATOR) + SEPARATOR + Hashing.md5((String)StringUtils.substringAfter((String)dsId, (String)SEPARATOR));
            CloudIndexClient indexClient = this.getIndexClient(info);
            String query = String.format("oaftype:result AND deletedbyinference:false AND collectedfromdatasourceid:\"%s\"", collectedFrom);
            log.debug((Object)String.format("query on %s: %s", info.getFormat(), query));
            QueryResponse rsp = indexClient.query(query, Integer.valueOf(1));
            long count = rsp.getResults().getNumFound();
            SolrDocument doc = (SolrDocument)Iterables.getFirst((Iterable)rsp.getResults(), (Object)new SolrDocument());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("got document %s", doc.toString()));
            }
            if (doc.isEmpty()) {
                throw new ApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), String.format("cannot find document matching query: %s", query));
            }
            String date = this.getDate(doc);
            return new IndexRecordsInfo(count, date);
        }
        catch (Throwable e) {
            throw new ApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), "Error querying publications from: " + dsId, e);
        }
    }

    private String getDate(SolrDocument doc) throws ApiException {
        List dsversion = (List)doc.get((Object)DSVERSION);
        if (dsversion == null || dsversion.isEmpty()) {
            throw new ApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), String.format("cannot find %s in matched solr document", DSVERSION));
        }
        Date date = (Date)Iterables.getLast((Iterable)dsversion);
        return DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd");
    }

    public String getLastIndexingDate(IndexDsInfo info) throws ApiException {
        try {
            QueryResponse rsp = this.getIndexClient(info).query("oaftype:datasource", Integer.valueOf(1));
            SolrDocument doc = (SolrDocument)Iterables.getFirst((Iterable)rsp.getResults(), null);
            String dsversion = doc.get((Object)DSVERSION).toString();
            return StringUtils.substringBefore((String)dsversion, (String)"T");
        }
        catch (CloudIndexClientException e) {
            throw new ApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), "Error querying index DS profile: " + info, (Throwable)e);
        }
    }

    private synchronized CloudIndexClient getIndexClient(IndexDsInfo info) throws CloudIndexClientException {
        if (!indexClientMap.containsKey(info.getColl())) {
            indexClientMap.put(info.getColl(), CloudIndexClientFactory.newIndexClient((String)info.getIndexBaseUrl(), (String)info.getColl(), (boolean)false));
        }
        return (CloudIndexClient)indexClientMap.get(info.getColl());
    }
}

