/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.datasource.clients;

import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.openaire.exporter.datasource.ApiException;
import eu.dnetlib.openaire.exporter.datasource.clients.utils.IndexDsInfo;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class ISLookupClient {
    private static final Log log = LogFactory.getLog(ISLookupClient.class);
    @Autowired
    private OpenaireExporterConfig config;
    @Autowired
    private ISLookUpService isLookUpService;

    @Cacheable(value={"datasources-is-cache"})
    public IndexDsInfo calculateCurrentIndexDsInfo() throws ApiException {
        log.warn((Object)"calculateCurrentIndexDsInfo(): not using cache");
        try {
            String queryUrl = IOUtils.toString((InputStream)this.config.getFindSolrIndexUrl().getInputStream(), (Charset)Charset.defaultCharset());
            String queryDs = IOUtils.toString((InputStream)this.config.getFindIndexDsInfo().getInputStream(), (Charset)Charset.defaultCharset());
            String indexBaseUrl = this.isLookUpService.getResourceProfileByQuery(queryUrl);
            String[] arr = this.isLookUpService.getResourceProfileByQuery(queryDs).split("@@@");
            return new IndexDsInfo(indexBaseUrl, arr[0].trim(), arr[1].trim(), arr[2].trim());
        }
        catch (Exception e) {
            throw new ApiException(HttpStatus.INTERNAL_SERVER_ERROR.value(), "Error querying information system");
        }
    }
}

