package eu.dnetlib;

import javax.sql.DataSource;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.ServerAddress;
import eu.dnetlib.OpenaireExporterConfig.Jdbc;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreService;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Created by claudio on 07/07/2017.
 */
@Configuration
public class DNetOpenaireExporterBeanFactory {

	@Autowired
	private OpenaireExporterConfig config;

	@Bean
	public ISLookUpService getLookUpService() {
		return getServiceStub(ISLookUpService.class, config.getIsLookupUrl());
	}

	@Bean
	public ObjectStoreService getObjectStoreService() {
		return getServiceStub(ObjectStoreService.class, config.getObjectStoreServiceUrl());
	}

	@Bean
	public ISRegistryService getRegistryService() {
		return getServiceStub(ISRegistryService.class, config.getIsRegistryServiceUrl());
	}

	@SuppressWarnings("unchecked")
	private <T> T getServiceStub(final Class<T> clazz, final String endpoint) {
		final JaxWsProxyFactoryBean jaxWsProxyFactory = new JaxWsProxyFactoryBean();
		jaxWsProxyFactory.setServiceClass(clazz);
		jaxWsProxyFactory.setAddress(endpoint);
		return (T) jaxWsProxyFactory.create();
	}

	@Bean
	public DataSource getSqlDataSource() {
		final Jdbc jdbc = config.getJdbc();
		return getDatasource(
				jdbc.getDriverClassName(),
				jdbc.getUrl(),
				jdbc.getUser(),
				jdbc.getPwd(),
				jdbc.getMinIdle(),
				jdbc.getMaxRows());
	}

	private BasicDataSource getDatasource(String driverClassName, String jdbcUrl, String jdbcUser, String jdbcPwd, int jdbcMinIdle, int jdbcMaxIdle) {
		final BasicDataSource d = new BasicDataSource();
		d.setDriverClassName(driverClassName);
		d.setUrl(jdbcUrl);
		d.setUsername(jdbcUser);
		d.setPassword(jdbcPwd);
		d.setMinIdle(jdbcMinIdle);
		d.setMaxIdle(jdbcMaxIdle);
		return d;
	}

	@Bean
	public MongoClient getMongoClient() {
		return new MongoClient(
				new ServerAddress(config.getDatasource().getMongoHost(), config.getDatasource().getMongoPort()),
				MongoClientOptions.builder().connectionsPerHost(config.getDatasource().getMongoConnectionsPerHost()).build());
	}

}
