package eu.dnetlib.openaire.exporter.community;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModelProperty;

@JsonAutoDetect
public class CommunityContentprovider {

	@ApiModelProperty(value = "OpenAIRE identifier for this content provider, if available", required = false)
	private String openaireId;

	@NotNull
	@ApiModelProperty(value = "the community identifier this content provider belongs to", required = true)
	private String communityId;

	@NotNull
	@ApiModelProperty(value = "identifies this content provider within the context it belongs to", required = true)
	private String id;

	@ApiModelProperty(value = "content provider name", required = false)
	private String name;

	@NotNull
	@ApiModelProperty(value = "content provider official name", required = true)
	private String officialname;

	public String getOpenaireId() {
		return openaireId;
	}

	public void setOpenaireId(final String openaireId) {
		this.openaireId = openaireId;
	}

	public String getCommunityId() {
		return communityId;
	}

	public void setCommunityId(final String communityId) {
		this.communityId = communityId;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getOfficialname() {
		return officialname;
	}

	public void setOfficialname(final String officialname) {
		this.officialname = officialname;
	}

}
