package eu.dnetlib.openaire.exporter.community;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModelProperty;

@JsonAutoDetect
public class CommunityProject {

	@ApiModelProperty(value = "OpenAIRE identifier for this project, if available", required = false)
	private String openaireId;

	@ApiModelProperty(value = "the community identifier this project belongs to", required = true)
	private String communityId;

	@ApiModelProperty(value = "identifies this project within the context it belongs to", required = true)
	private String id;

	@ApiModelProperty(value = "project name", required = true)
	private String name;

	@ApiModelProperty(value = "project acronym", required = false)
	private String acronym;

	@ApiModelProperty(value = "project funder", required = true)
	private String funder;

	@ApiModelProperty(value = "project grant id", required = true)
	private String grantId;

	public String getOpenaireId() {
		return openaireId;
	}

	public void setOpenaireId(final String openaireId) {
		this.openaireId = openaireId;
	}

	public String getCommunityId() {
		return communityId;
	}

	public void setCommunityId(final String communityId) {
		this.communityId = communityId;
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getAcronym() {
		return acronym;
	}

	public void setAcronym(final String acronym) {
		this.acronym = acronym;
	}

	public String getFunder() {
		return funder;
	}

	public void setFunder(final String funder) {
		this.funder = funder;
	}

	public String getGrantId() {
		return grantId;
	}

	public void setGrantId(final String grantId) {
		this.grantId = grantId;
	}

}
