package eu.dnetlib.openaire.exporter.community;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModelProperty;

@JsonAutoDetect
public class CommunitySummary {

	@ApiModelProperty("identifies the community")
	protected String id;

	@ApiModelProperty("values for this field reflect the index field _community_ in the index, e.g. 'egi||EGI Federation'")
	protected String queryId;

	@ApiModelProperty("community name")
	protected String name;

	@ApiModelProperty("community short name")
	protected String shortName;

	@ApiModelProperty("community description")
	protected String description;

	@ApiModelProperty("list of community manager emails")
	protected List<String> managers;

	@ApiModelProperty("http url for the community logo")
	protected String logoUrl;

	public CommunitySummary() {
	}

	public CommunitySummary(final String id,
			final String queryId,
			final String name,
			final String shortName,
			final String description,
			final List<String> managers,
			final String logoUrl) {
		this.id = id;
		this.queryId = queryId;
		this.name = name;
		this.shortName = shortName;
		this.description = description;
		this.managers = managers;
		this.logoUrl = logoUrl;
	}

	public CommunitySummary(final CommunitySummary summary) {
		this(	summary.getId(),
				summary.getQueryId(),
				summary.getName(),
				summary.getShortName(),
				summary.getDescription(),
				summary.getManagers(),
				summary.getLogoUrl());
	}

	public String getId() {
		return id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getQueryId() {
		return queryId;
	}

	public void setQueryId(final String queryId) {
		this.queryId = queryId;
	}

	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	public String getShortName() {
		return shortName;
	}

	public void setShortName(final String shortName) {
		this.shortName = shortName;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	public List<String> getManagers() {
		return managers;
	}

	public void setManagers(final List<String> managers) {
		this.managers = managers;
	}

	public String getLogoUrl() {
		return logoUrl;
	}

	public void setLogoUrl(final String logoUrl) {
		this.logoUrl = logoUrl;
	}

}
