package eu.dnetlib.openaire.exporter.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.collect.Lists;
import eu.dnetlib.openaire.exporter.model.datasource.DatasourceInfo;
import io.swagger.annotations.ApiModel;

@ApiModel
@JsonAutoDetect
public class DatasourceResponse extends Response {

	private List<DatasourceInfo> datasourceInfo = Lists.newArrayList();

	public DatasourceResponse addDatasourceInfo(final DatasourceInfo datasourceInfo) {
		getDatasourceInfo().add(datasourceInfo);
		return this;
	}

	public List<DatasourceInfo> getDatasourceInfo() {
		return datasourceInfo;
	}

	public DatasourceResponse setDatasourceInfo(final List<DatasourceInfo> datasourceInfo) {
		this.datasourceInfo = datasourceInfo;
		return this;
	}

}
