package eu.dnetlib.openaire.exporter.model;

import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.GsonBuilder;
import io.swagger.annotations.ApiModel;

@ApiModel
@JsonAutoDetect
public class Header {

	private long total;
	private int page;
	private int size;
	private long time;
	private int statusCode;
	private List<String> errors;

	@JsonIgnore
	private Queue<Throwable> exceptions;

	public static Header newInsance() {
		return new Header();
	}

	public Header() {
	}

	public long getTime() {
		return time;
	}

	public Header setTime(final long time) {
		this.time = time;
		return this;
	}

	public int getStatusCode() {
		return statusCode;
	}

	public Header setStatusCode(final int statusCode) {
		this.statusCode = statusCode;
		return this;
	}

	public long getTotal() {
		return total;
	}

	public int getPage() {
		return page;
	}

	public int getSize() {
		return size;
	}

	public Header setPage(final int page) {
		this.page = page;
		return this;
	}

	public Header setSize(final int size) {
		this.size = size;
		return this;
	}

	public Header setTotal(final long total) {
		this.total = total;
		return this;
	}

	public Queue<Throwable> getExceptions() {
		return exceptions;
	}

	public Header setExceptions(final Queue<Throwable> exceptions) {
		this.exceptions = exceptions;
		return this;
	}

	public List<String> getErrors() {
		return getExceptions().stream()
				.map(e -> e.getMessage())
				.collect(Collectors.toList());
	}

	public Header setErrors(final List<String> errors) {
		this.errors = errors;
		return this;
	}

	public String toJson() {
		return new GsonBuilder().setPrettyPrinting().create().toJson(this);
	}

}
