package eu.dnetlib.openaire.exporter.model.datasource;

import java.sql.Date;
import java.util.Set;
import javax.persistence.Transient;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

/**
 * Created by claudio on 12/09/16.
 */
@JsonAutoDetect
@ApiModel(value = "Datasource model", description = "provides information about the datasource")
public class DatasourceDetails extends DatasourceIgnoredProperties {

	@NotBlank
	@ApiModelProperty(position = 0)
	private String id;

	@Transient
	@ApiModelProperty(position = 1)
	private String openaireId;

	@NotBlank
	@Length(max = 300)
	@ApiModelProperty(position = 2)
	private String officialname;

	@NotBlank
	@Length(max = 300)
	@ApiModelProperty(position = 3)
	private String englishname;

	@ApiModelProperty(position = 4)
	private String websiteurl;

	@ApiModelProperty(position = 5)
	private String logourl;

	@Email
	@ApiModelProperty(position = 6)
	private String contactemail;

	@ApiModelProperty(position = 7)
	private Double latitude;

	@ApiModelProperty(position = 8)
	private Double longitude;

	@ApiModelProperty(position = 9)
	private String timezone;

	@NotBlank
	@Length(min = 12, max = 12)
	@ApiModelProperty(position = 10)
	private String namespaceprefix;

	@ApiModelProperty(position = 11)
	private String languages;

	@ApiModelProperty(position = 12)
	private Date dateofvalidation;

	@NotBlank
	@Length(max = 100)
	@ApiModelProperty(position = 13)
	private String typology;

	@ApiModelProperty(position = 14)
	private Date dateofcollection;

	@ApiModelProperty(position = 15)
	private String platform;

	@ApiModelProperty(position = 16)
	private String activationId;

	@ApiModelProperty(position = 17)
	private String description;

	@ApiModelProperty(position = 18)
	private String issn;

	@ApiModelProperty(position = 19)
	private String eissn;

	@ApiModelProperty(position = 20)
	private String lissn;

	@Email
	@ApiModelProperty(position = 21)
	private String registeredby;

	@ApiModelProperty(position = 22)
	private String subjects;

	@ApiModelProperty(position = 23)
	protected String aggregator = "OPENAIRE";

	@ApiModelProperty(position = 24)
	protected String collectedfrom;

	@ApiModelProperty(position = 25)
	private Boolean managed;

	@ApiModelProperty(position = 26)
	private Set<OrganizationDetails> organizations;

	@ApiModelProperty(position = 27)
	private Set<IdentitiesDetails> identities;

	public String getId() {
		return id;
	}

	public String getOpenaireId() {
		return openaireId;
	}

	public String getOfficialname() {
		return officialname;
	}

	public String getEnglishname() {
		return englishname;
	}

	public String getWebsiteurl() {
		return websiteurl;
	}

	public String getLogourl() {
		return logourl;
	}

	public String getContactemail() {
		return contactemail;
	}

	public Double getLatitude() {
		return latitude;
	}

	public Double getLongitude() {
		return longitude;
	}

	public String getTimezone() {
		return timezone;
	}

	public String getLanguages() {
		return languages;
	}

	public String getNamespaceprefix() {
		return namespaceprefix;
	}

	public Date getDateofvalidation() {
		return dateofvalidation;
	}

	public String getTypology() {
		return typology;
	}

	public Date getDateofcollection() {
		return dateofcollection;
	}

	public String getPlatform() {
		return platform;
	}

	public String getActivationId() {
		return activationId;
	}

	public String getDescription() {
		return description;
	}

	public String getIssn() {
		return issn;
	}

	public String getEissn() {
		return eissn;
	}

	public String getLissn() {
		return lissn;
	}

	public String getRegisteredby() {
		return registeredby;
	}

	public String getSubjects() {
		return subjects;
	}

	public String getAggregator() {
		return aggregator;
	}

	public String getCollectedfrom() {
		return collectedfrom;
	}

	public Boolean getManaged() {
		return managed;
	}

	public Set<OrganizationDetails> getOrganizations() {
		return organizations;
	}

	public Set<IdentitiesDetails> getIdentities() {
		return identities;
	}

	public DatasourceDetails setId(final String id) {
		this.id = id;
		return this;
	}

	public DatasourceDetails setOpenaireId(final String openaireId) {
		this.openaireId = openaireId;
		return this;
	}

	public DatasourceDetails setOfficialname(final String officialname) {
		this.officialname = officialname;
		return this;
	}

	public DatasourceDetails setEnglishname(final String englishname) {
		this.englishname = englishname;
		return this;
	}

	public DatasourceDetails setWebsiteurl(final String websiteurl) {
		this.websiteurl = websiteurl;
		return this;
	}

	public DatasourceDetails setLogourl(final String logourl) {
		this.logourl = logourl;
		return this;
	}

	public DatasourceDetails setContactemail(final String contactemail) {
		this.contactemail = contactemail;
		return this;
	}

	public DatasourceDetails setLatitude(final Double latitude) {
		this.latitude = latitude;
		return this;
	}

	public DatasourceDetails setLongitude(final Double longitude) {
		this.longitude = longitude;
		return this;
	}

	public DatasourceDetails setTimezone(final String timezone) {
		this.timezone = timezone;
		return this;
	}

	public DatasourceDetails setLanguages(final String languages) {
		this.languages = languages;
		return this;
	}

	public DatasourceDetails setNamespaceprefix(final String namespaceprefix) {
		this.namespaceprefix = namespaceprefix;
		return this;
	}

	public DatasourceDetails setDateofvalidation(final Date dateofvalidation) {
		this.dateofvalidation = dateofvalidation;
		return this;
	}

	public DatasourceDetails setTypology(final String typology) {
		this.typology = typology;
		return this;
	}

	public DatasourceDetails setDateofcollection(final Date dateofcollection) {
		this.dateofcollection = dateofcollection;
		return this;
	}

	public DatasourceDetails setPlatform(final String platform) {
		this.platform = platform;
		return this;
	}

	public DatasourceDetails setActivationId(final String activationId) {
		this.activationId = activationId;
		return this;
	}

	public DatasourceDetails setDescription(final String description) {
		this.description = description;
		return this;
	}

	public DatasourceDetails setIssn(final String issn) {
		this.issn = issn;
		return this;
	}

	public DatasourceDetails setEissn(final String eissn) {
		this.eissn = eissn;
		return this;
	}

	public DatasourceDetails setLissn(final String lissn) {
		this.lissn = lissn;
		return this;
	}

	public DatasourceDetails setRegisteredby(final String registeredby) {
		this.registeredby = registeredby;
		return this;
	}

	public DatasourceDetails setSubjects(final String subjects) {
		this.subjects = subjects;
		return this;
	}

	public DatasourceDetails setAggregator(final String aggregator) {
		this.aggregator = aggregator;
		return this;
	}

	public DatasourceDetails setCollectedfrom(final String collectedfrom) {
		this.collectedfrom = collectedfrom;
		return this;
	}


	public DatasourceDetails setManaged(final Boolean managed) {
		this.managed = managed;
		return this;
	}

	public DatasourceDetails setOrganizations(final Set<OrganizationDetails> organizations) {
		this.organizations = organizations;
		return this;
	}

	public DatasourceDetails setIdentities(final Set<IdentitiesDetails> identities) {
		this.identities = identities;
		return this;
	}

}

