package eu.dnetlib.openaire.exporter.model.datasource.db;

import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import eu.dnetlib.enabling.datasources.common.ApiParam;
import io.swagger.annotations.ApiModel;

/**
 * Created by claudio on 13/04/2017.
 */
@Entity
@Table(name = "dsm_apiparams")
@JsonIgnoreProperties(ignoreUnknown = true)
@ApiModel(value = "Datasource Api params model", description = "describes the datasource api params")
public class ApiParamDbEntry implements ApiParam {

	@EmbeddedId
	protected ApiParamKeyDbEntry id;

	protected String value;

	public ApiParamDbEntry() {}

	public ApiParam setId(final ApiParamKeyDbEntry id) {
		this.id = id;
		return this;
	}

	@JsonIgnore
	public ApiParamKeyDbEntry getId() {
		return id;
	}

	public String getValue() {
		return value;
	}

	public void setValue(final String value) {
		this.value = value;
	}

	@Override
	public String getParam() {
		return id.getParam();
	}

	@Override
	public void setParam(final String param) {
		final ApiParamKeyDbEntry apk = new ApiParamKeyDbEntry();
		apk.setParam(param);
		setId(apk);
	}

}
