package eu.dnetlib.openaire.exporter.model.datasource.db;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import com.fasterxml.jackson.annotation.JsonAutoDetect;

import eu.dnetlib.enabling.datasources.common.BrowseTerm;
import io.swagger.annotations.ApiModel;

/**
 * Created by claudio on 20/04/2017.
 */
@Entity
@Table(name = "browse_countries")
@ApiModel
@JsonAutoDetect
public class CountryTerm implements Comparable<CountryTerm>, BrowseTerm {

	@Id
	private String term;
	private long total;

	@Override
	public String getTerm() {
		return term;
	}

	public void setTerm(final String term) {
		this.term = term;
	}

	@Override
	public long getTotal() {
		return total;
	}

	public void setTotal(final long total) {
		this.total = total;
	}

	@Override
	public int compareTo(final CountryTerm o) {
		return getTerm().compareTo(o.getTerm());
	}

}
