package eu.dnetlib.swagger.configuration;

import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.OpenaireExporterConfig.Swagger;
import eu.dnetlib.openaire.exporter.community.CommunityApiController;
import eu.dnetlib.openaire.exporter.datasource.DatasourcesApiController;
import eu.dnetlib.openaire.exporter.funders.FundersApiController;
import eu.dnetlib.openaire.exporter.model.project.ProjectApi;
import eu.dnetlib.openaire.exporter.project.ProjectsController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import static springfox.documentation.builders.RequestHandlerSelectors.basePackage;

@Configuration
@EnableSwagger2
public class SwaggerDocumentationConfig {

	private static final Log log = LogFactory.getLog(SwaggerDocumentationConfig.class);

	@Autowired
	private OpenaireExporterConfig config;

    @Bean
    public Docket dsm() {
        return _docket(
        		"Datasource Manager",
		        DatasourcesApiController.class.getPackage().getName(),
		        config.getSwaggerDsm());
    }

	@Bean
	public Docket projects() {
		return _docket(
				"OpenAIRE Projects",
				ProjectsController.class.getPackage().getName(),
				config.getSwaggerProjects());
	}

	@Bean
	public Docket funders() {
		return _docket(
				"OpenAIRE Funders",
				FundersApiController.class.getPackage().getName(),
				config.getSwaggerFunders());
	}

	@Bean
	public Docket communities() {
		return _docket(
				"OpenAIRE Communities",
				CommunityApiController.class.getPackage().getName(),
				config.getSwaggerCommunities());
	}

	private Docket _docket(final String groupName, final String controllerPackage, final Swagger swag) {
		return new Docket(DocumentationType.SWAGGER_2)
				.groupName(groupName)
				.select()
				.apis(basePackage(controllerPackage))
				.build()
				.directModelSubstitute(org.joda.time.LocalDate.class, java.sql.Date.class)
				.directModelSubstitute(org.joda.time.DateTime.class, java.util.Date.class)
				.apiInfo(apiInfo(swag));
	}

	private ApiInfo apiInfo(final Swagger swag) {
		return new ApiInfoBuilder()
				.title(swag.getApiTitle())
				.description(swag.getApiDescription())
				.license(swag.getApiLicense())
				.licenseUrl(swag.getApiLicenseUrl())
				.termsOfServiceUrl("")
				.version("1.0.0")
				.contact(new Contact(
						swag.getApiContactName(),
						swag.getApiContactUrl(),
						swag.getApiContactEmail()))
				.build();
	}

}
