/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class OperationManager {
    private static final Log log = LogFactory.getLog(OperationManager.class);
    private static final long SLEEP_TIME = 1000L;
    private static final int Q_SIZE = 100;
    private static final int POOL_SIZE = 5;
    private BlockingQueue<Runnable> ops = new ArrayBlockingQueue(100);
    private ExecutorService executor;

    @PostConstruct
    public void init() {
        this.executor = this.getExecutor();
    }

    public int dropAll() {
        List<Runnable> lostOperations = this.executor.shutdownNow();
        log.warn((Object)String.format("discarding %s operations", lostOperations.size()));
        this.executor = this.getExecutor();
        return lostOperations.size();
    }

    public int getOpSize() {
        return this.ops.size();
    }

    public void addOperation(Runnable op) {
        this.executor.execute(op);
    }

    @PreDestroy
    public void tearDown() throws InterruptedException {
        this.executor.shutdown();
        boolean done = this.executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        log.debug((Object)String.format("All operations were completed so far? %s", done));
    }

    private ThreadPoolExecutor getExecutor() {
        return new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, this.ops);
    }
}

