/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.community;

import eu.dnetlib.openaire.exporter.community.CommunityApiCore;
import eu.dnetlib.openaire.exporter.community.CommunityContentprovider;
import eu.dnetlib.openaire.exporter.community.CommunityDetails;
import eu.dnetlib.openaire.exporter.community.CommunityException;
import eu.dnetlib.openaire.exporter.community.CommunityNotFoundException;
import eu.dnetlib.openaire.exporter.community.CommunityProject;
import eu.dnetlib.openaire.exporter.community.CommunitySummary;
import eu.dnetlib.openaire.exporter.community.CommunityWritableProperties;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"OpenAIRE Communities API"}, description="the OpenAIRE Community API")
public class CommunityApiController {
    @Autowired
    private CommunityApiCore communityApiCore;

    @RequestMapping(value={"/community/communities"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get all community profiles", notes="get all community profiles", tags={"Community", "Read"}, response=CommunitySummary[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CommunitySummary[].class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public List<CommunitySummary> listCommunities() throws CommunityException {
        return this.communityApiCore.listCommunities();
    }

    @RequestMapping(value={"/community/{id}"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get community profile", notes="get community profile", tags={"Community", "Read"}, response=CommunityDetails.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CommunityDetails.class), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public CommunityDetails getCommunity(@PathVariable String id) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.getCommunity(id);
    }

    @RequestMapping(value={"/community/{id}"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="update community details", notes="update community details", tags={"Community", "Read"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public void setCommunity(@PathVariable String id, @RequestBody CommunityWritableProperties properties) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.setCommunity(id, properties);
    }

    @RequestMapping(value={"/community/{id}/projects"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get community projects", notes="get community projects", tags={"Community projects", "Read"}, response=CommunityProject[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CommunityProject[].class), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public List<CommunityProject> getCommunityProjects(@PathVariable String id) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.getCommunityProjects(id);
    }

    @RequestMapping(value={"/community/{id}/projects"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="associate a project to the community", notes="associate a project to the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public void addCommunityProject(@PathVariable String id, @RequestBody CommunityProject project) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.addCommunityProject(id, project);
    }

    @RequestMapping(value={"/community/{id}/projects"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ApiOperation(value="remove a project from the community", notes="remove a project from the community", tags={"Community projects", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public void deleteCommunityProject(@PathVariable String id, @RequestBody String projectId) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.removeCommunityProject(id, projectId);
    }

    @RequestMapping(value={"/community/{id}/contentproviders"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiOperation(value="get the list of content providers associated to a given community", notes="get the list of content providers associated to a given community", tags={"Community content providers", "Read"}, response=CommunityContentprovider[].class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CommunityContentprovider[].class), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public List<CommunityContentprovider> getCommunityContentproviders(@PathVariable String id) throws CommunityException, CommunityNotFoundException {
        return this.communityApiCore.getCommunityContentproviders(id);
    }

    @RequestMapping(value={"/community/{id}/contentproviders"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiOperation(value="associate a content provider to the community", notes="associate a content provider to the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public void addCommunityContentprovider(@PathVariable String id, @RequestBody CommunityContentprovider contentprovider) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.addCommunityContentprovider(id, contentprovider);
    }

    @RequestMapping(value={"/community/{id}/contentproviders"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ApiOperation(value="remove the association between a content provider and the community", notes="remove the association between a content provider and the community", tags={"Community content providers", "Write"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="not found", response=CommunityNotFoundException.class), @ApiResponse(code=500, message="unexpected error", response=CommunityException.class)})
    public void removeCommunityContentprovider(@PathVariable String id, @RequestBody String contentproviderId) throws CommunityException, CommunityNotFoundException {
        this.communityApiCore.removeCommunityContentProvider(id, contentproviderId);
    }
}

