/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.community;

import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import eu.dnetlib.openaire.exporter.community.CommunityConstants;
import eu.dnetlib.openaire.exporter.community.CommunityContentprovider;
import eu.dnetlib.openaire.exporter.community.CommunityDetails;
import eu.dnetlib.openaire.exporter.community.CommunityException;
import eu.dnetlib.openaire.exporter.community.CommunityMappingUtils;
import eu.dnetlib.openaire.exporter.community.CommunityNotFoundException;
import eu.dnetlib.openaire.exporter.community.CommunityProject;
import eu.dnetlib.openaire.exporter.community.CommunitySummary;
import eu.dnetlib.openaire.exporter.community.CommunityWritableProperties;
import eu.dnetlib.openaire.exporter.datasource.clients.ISClient;
import eu.dnetlib.openaire.exporter.funders.context.Category;
import eu.dnetlib.openaire.exporter.funders.context.Concept;
import eu.dnetlib.openaire.exporter.funders.context.Context;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommunityApiCore {
    private static final Log log = LogFactory.getLog(CommunityApiCore.class);
    @Autowired
    private ISClient isClient;

    public List<CommunitySummary> listCommunities() throws CommunityException {
        return this.getContextMap().values().stream().filter(context -> !CommunityConstants.communityBlackList.contains(context.getId())).map(CommunityMappingUtils::asCommunitySummary).collect(Collectors.toList());
    }

    public CommunityDetails getCommunity(String id) throws CommunityException, CommunityNotFoundException {
        Context context = (Context)this.getContextMap().get(id);
        if (context == null || CommunityConstants.communityBlackList.contains(id)) {
            throw new CommunityNotFoundException(String.format("community '%s' does not exist", id));
        }
        return CommunityMappingUtils.asCommunityProfile((Context)context);
    }

    public void setCommunity(String id, CommunityWritableProperties details) throws CommunityException, CommunityNotFoundException {
        this.getCommunity(id);
        this.isClient.updateContextAttribute(id, "label", details.getShortName());
        this.isClient.updateContextParam(id, "name", details.getName());
        this.isClient.updateContextParam(id, "description", details.getDescription());
        this.isClient.updateContextParam(id, "logourl", details.getLogoUrl());
        this.isClient.updateContextParam(id, "manager", Joiner.on((String)", ").join((Iterable)details.getManagers()));
        this.isClient.updateContextParam(id, "subject", Joiner.on((String)", ").join((Iterable)details.getSubjects()));
    }

    public List<CommunityProject> getCommunityProjects(String id) throws CommunityException, CommunityNotFoundException {
        this.getCommunity(id);
        return this._getCommunityInfo(id, "::projects", c -> CommunityMappingUtils.asCommunityProject((String)id, (Concept)c));
    }

    public void addCommunityProject(String id, CommunityProject project) throws CommunityException, CommunityNotFoundException {
        if (!StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)project.getCommunityId())) {
            throw new CommunityException("parameters 'id' and project.communityId must be coherent");
        }
        if (StringUtils.isBlank((CharSequence)project.getId())) {
            throw new CommunityException("parameter 'id' must be non empty");
        }
        Map projects = this.getCommunityProjectMap(id);
        if (projects.containsKey(project.getId())) {
            throw new CommunityException(String.format("project '%s' already defined in context '%s'", project.getId(), id));
        }
        this.isClient.addConcept(id, id + "::projects", CommunityMappingUtils.asProjectXML((String)id, (CommunityProject)project));
    }

    public void removeCommunityProject(String id, String projectId) throws CommunityException, CommunityNotFoundException {
        Map projects = this.getCommunityProjectMap(id);
        if (!projects.containsKey(projectId)) {
            throw new CommunityNotFoundException(String.format("project '%s' doesn't exist within context '%s'", projectId, id));
        }
        this.isClient.removeConcept(id, id + "::projects", id + "::projects" + "::" + projectId);
    }

    public List<CommunityContentprovider> getCommunityContentproviders(String id) throws CommunityException, CommunityNotFoundException {
        this.getCommunity(id);
        return this._getCommunityInfo(id, "::contentproviders", c -> CommunityMappingUtils.asCommunityDataprovider((String)id, (Concept)c));
    }

    public void addCommunityContentprovider(String id, CommunityContentprovider cp) throws CommunityException, CommunityNotFoundException {
        if (!StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)cp.getCommunityId())) {
            throw new CommunityException("parameters 'id' and cp.communityId must be coherent");
        }
        if (StringUtils.isBlank((CharSequence)cp.getId())) {
            throw new CommunityException("parameter 'id' must be non empty");
        }
        Map cps = this.getCommunityContentproviderMap(id);
        if (cps.containsKey(cp.getId())) {
            throw new CommunityException(String.format("content provider '%s' already defined in context '%s'", cp.getId(), id));
        }
        this.isClient.addConcept(id, id + "::contentproviders", CommunityMappingUtils.asContentProviderXML((String)id, (CommunityContentprovider)cp));
    }

    public void removeCommunityContentProvider(String id, String contentproviderId) throws CommunityException, CommunityNotFoundException {
        Map providers = this.getCommunityContentproviderMap(id);
        if (!providers.containsKey(contentproviderId)) {
            throw new CommunityNotFoundException(String.format("content provider '%s' doesn't exist within context '%s'", contentproviderId, id));
        }
        this.isClient.removeConcept(id, id + "::contentproviders", id + "::contentproviders" + "::" + contentproviderId);
    }

    private Map<String, CommunityProject> getCommunityProjectMap(String id) throws CommunityException, CommunityNotFoundException {
        return this.getCommunityProjects(id).stream().collect(Collectors.toMap(CommunityProject::getId, Functions.identity(), (p1, p2) -> {
            log.warn((Object)("duplicate project found! " + p1.getId()));
            return p2;
        }));
    }

    private Map<String, CommunityContentprovider> getCommunityContentproviderMap(String id) throws CommunityException, CommunityNotFoundException {
        return this.getCommunityContentproviders(id).stream().collect(Collectors.toMap(CommunityContentprovider::getId, Functions.identity(), (cp1, cp2) -> {
            log.warn((Object)("duplicate content provider found! " + cp1.getId()));
            return cp2;
        }));
    }

    private Map<String, Context> getContextMap() throws CommunityException {
        try {
            return this.isClient.getCommunityContextMap();
        }
        catch (IOException e) {
            throw new CommunityException(e);
        }
    }

    private <R> List<R> _getCommunityInfo(String id, String idSuffix, Function<Concept, R> mapping) throws CommunityException {
        Map categories;
        Category category;
        Map contextMap = this.getContextMap();
        Context context = (Context)contextMap.get(id);
        if (context != null && (category = (Category)(categories = context.getCategories()).get(id + idSuffix)) != null) {
            return category.getConcepts().stream().map(mapping).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }
}

