/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.community;

import com.google.common.escape.Escaper;
import com.google.common.xml.XmlEscapers;
import eu.dnetlib.openaire.exporter.Utils;
import eu.dnetlib.openaire.exporter.community.CommunityContentprovider;
import eu.dnetlib.openaire.exporter.community.CommunityDetails;
import eu.dnetlib.openaire.exporter.community.CommunityProject;
import eu.dnetlib.openaire.exporter.community.CommunitySummary;
import eu.dnetlib.openaire.exporter.funders.context.Concept;
import eu.dnetlib.openaire.exporter.funders.context.Context;
import eu.dnetlib.openaire.exporter.funders.context.Param;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CommunityMappingUtils {
    public static CommunitySummary asCommunitySummary(Context c) {
        CommunitySummary summary = new CommunitySummary();
        summary.setId(c.getId());
        summary.setShortName(c.getLabel());
        summary.setQueryId(c.getId() + "||" + c.getLabel());
        Map params = c.getParams();
        if (params.containsKey("description")) {
            summary.setDescription(CommunityMappingUtils.asCsv((List)((List)params.get("description"))));
        }
        if (params.containsKey("logourl")) {
            summary.setLogoUrl(CommunityMappingUtils.asCsv((List)((List)params.get("logourl"))));
        }
        if (params.containsKey("name")) {
            summary.setName(CommunityMappingUtils.asCsv((List)((List)params.get("name"))));
        }
        if (params.containsKey("manager")) {
            summary.setManagers(CommunityMappingUtils.asValues((List)((List)params.get("manager"))).collect(Collectors.toList()));
        }
        return summary;
    }

    public static CommunityDetails asCommunityProfile(Context c) {
        CommunityDetails p = new CommunityDetails(CommunityMappingUtils.asCommunitySummary((Context)c));
        p.setType(c.getType());
        p.setCreationDate(c.getDateofcreation());
        Map params = c.getParams();
        if (params.containsKey("subject")) {
            p.setSubjects(CommunityMappingUtils.asValues((List)((List)params.get("subject"))).collect(Collectors.toList()));
        }
        return p;
    }

    public static CommunityProject asCommunityProject(String communityId, Concept c) {
        Map p = c.getParams();
        CommunityProject project = new CommunityProject();
        project.setCommunityId(communityId);
        project.setId(StringUtils.substringAfterLast((String)c.getId(), (String)"::"));
        project.setOpenaireId(CommunityMappingUtils.firstValue((Map)p, (String)"openaireId"));
        project.setFunder(CommunityMappingUtils.firstValue((Map)p, (String)"funder"));
        project.setGrantId(CommunityMappingUtils.firstValue((Map)p, (String)"CD_PROJECT_NUMBER"));
        project.setName(CommunityMappingUtils.firstValue((Map)p, (String)"projectfullname"));
        project.setAcronym(CommunityMappingUtils.firstValue((Map)p, (String)"projectacronym"));
        return project;
    }

    public static CommunityContentprovider asCommunityDataprovider(String communityId, Concept c) {
        Map p = c.getParams();
        CommunityContentprovider d = new CommunityContentprovider();
        d.setCommunityId(communityId);
        d.setId(StringUtils.substringAfterLast((String)c.getId(), (String)"::"));
        d.setOpenaireId(CommunityMappingUtils.firstValue((Map)p, (String)"openaireId"));
        d.setName(CommunityMappingUtils.firstValue((Map)p, (String)"name"));
        d.setOfficialname(CommunityMappingUtils.firstValue((Map)p, (String)"officialname"));
        return d;
    }

    private static String firstValue(Map<String, List<Param>> p, String paramName) {
        Optional first = CommunityMappingUtils.asValues(p.get(paramName)).findFirst();
        return first.isPresent() ? (String)first.get() : null;
    }

    private static String asCsv(List<Param> params) {
        return CommunityMappingUtils.asValues(params).collect(Collectors.joining(", "));
    }

    private static Stream<String> asValues(List<Param> params) {
        return params == null ? Stream.empty() : params.stream().map(Param::getValue).distinct();
    }

    public static String asProjectXML(String contextId, CommunityProject project) {
        Escaper esc = XmlEscapers.xmlAttributeEscaper();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<concept claim='true' id='%s%s%s%s' label='%s'>\n", Utils.escape((Escaper)esc, (String)contextId), "::projects", "::", Utils.escape((Escaper)esc, (String)project.getId()), Utils.escape((Escaper)esc, (String)project.getAcronym())));
        sb.append(CommunityMappingUtils.paramXML((String)"projectfullname", (String)project.getName()));
        sb.append(CommunityMappingUtils.paramXML((String)"projectacronym", (String)project.getAcronym()));
        sb.append(CommunityMappingUtils.paramXML((String)"CD_PROJECT_NUMBER", (String)project.getGrantId()));
        sb.append(CommunityMappingUtils.paramXML((String)"funder", (String)project.getFunder()));
        sb.append(CommunityMappingUtils.paramXML((String)"openaireId", (String)project.getOpenaireId()));
        sb.append("</concept>\n");
        return sb.toString();
    }

    public static String asContentProviderXML(String contextId, CommunityContentprovider ccp) {
        Escaper esc = XmlEscapers.xmlAttributeEscaper();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("<concept claim='true' id='%s%s%s%s' label='%s'>\n", Utils.escape((Escaper)esc, (String)contextId), "::contentproviders", "::", Utils.escape((Escaper)esc, (String)ccp.getId()), Utils.escape((Escaper)esc, (String)ccp.getName())));
        sb.append(CommunityMappingUtils.paramXML((String)"openaireId", (String)ccp.getOpenaireId()));
        sb.append(CommunityMappingUtils.paramXML((String)"name", (String)ccp.getName()));
        sb.append(CommunityMappingUtils.paramXML((String)"officialname", (String)ccp.getOfficialname()));
        sb.append("</concept>\n");
        return sb.toString();
    }

    private static String paramXML(String paramName, String value) {
        return String.format("<param name='%s'>%s</param>\n", paramName, Utils.escape((Escaper)XmlEscapers.xmlContentEscaper(), (String)value));
    }
}

