/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.datasource;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.xml.XmlEscapers;
import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.enabling.datasources.common.AggregationInfo;
import eu.dnetlib.enabling.datasources.common.AggregationStage;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.enabling.datasources.common.Datasource;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.DsmForbiddenException;
import eu.dnetlib.openaire.exporter.datasource.clients.DatasourceDao;
import eu.dnetlib.openaire.exporter.datasource.clients.DatasourceDaoImpl;
import eu.dnetlib.openaire.exporter.datasource.clients.DatasourceIndexClient;
import eu.dnetlib.openaire.exporter.datasource.clients.ISClient;
import eu.dnetlib.openaire.exporter.datasource.clients.MongoLoggerClient;
import eu.dnetlib.openaire.exporter.datasource.clients.ObjectStoreClient;
import eu.dnetlib.openaire.exporter.datasource.clients.ResponseUtils;
import eu.dnetlib.openaire.exporter.datasource.clients.VocabularyClient;
import eu.dnetlib.openaire.exporter.model.ApiDetailsResponse;
import eu.dnetlib.openaire.exporter.model.ConversionUtils;
import eu.dnetlib.openaire.exporter.model.DatasourceResponse;
import eu.dnetlib.openaire.exporter.model.datasource.ApiDetails;
import eu.dnetlib.openaire.exporter.model.datasource.DatasourceDetails;
import eu.dnetlib.openaire.exporter.model.datasource.DatasourceInfo;
import eu.dnetlib.openaire.exporter.model.datasource.RequestFilter;
import eu.dnetlib.openaire.exporter.model.datasource.RequestSort;
import eu.dnetlib.openaire.exporter.model.datasource.RequestSortOrder;
import eu.dnetlib.openaire.exporter.model.datasource.db.DatasourceDbEntry;
import eu.dnetlib.openaire.exporter.vocabularies.Country;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Component;

@Component
public class DatasourceManagerCore {
    private static final Log log = LogFactory.getLog(DatasourceManagerCore.class);
    @Autowired
    private MongoLoggerClient mongoLoggerClient;
    @Autowired
    private ISClient isClient;
    @Autowired
    private ObjectStoreClient objectStoreClient;
    @Autowired
    private DatasourceIndexClient datasourceIndexClient;
    @Autowired
    private VocabularyClient vocabularyClient;
    @Autowired
    private DatasourceDao dsDao;
    @Autowired
    private OpenaireExporterConfig config;
    private ListeningExecutorService executor;

    @PostConstruct
    public void init() {
        this.executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)new ScheduledThreadPoolExecutor(this.config.getRequestWorkers(), new ThreadFactoryBuilder().setNameFormat("dsm-client-%d").build()));
    }

    public List<Country> listCountries() throws DsmException {
        return this.dsDao.listCountries();
    }

    public DatasourceResponse search(RequestSort requestSortBy, RequestSortOrder order, RequestFilter requestFilter, int page, int size) throws DsmException {
        ArrayList datasourceInfo = Lists.newArrayList();
        LinkedBlockingQueue errors = Queues.newLinkedBlockingQueue();
        CountDownLatch outerLatch = new CountDownLatch(2);
        Page dsPage = this.dsDao.search(requestSortBy, order, requestFilter, page, size);
        if (dsPage.getTotalElements() > 0L && dsPage.getNumberOfElements() > 0) {
            dsPage.forEach(d -> datasourceInfo.add(this.enrichDatasourceInfo(ConversionUtils.asDetails((DatasourceDbEntry)d), outerLatch, errors)));
            this.waitLatch(outerLatch, (Queue)errors, this.config.getRequestTimeout());
        }
        return ResponseUtils.datasourceResponse((List)datasourceInfo, (Queue)errors, (long)dsPage.getTotalElements());
    }

    public List<String> findBaseURLs(RequestFilter requestFilter, int page, int size) throws DsmException {
        return this.dsDao.findApiBaseURLs(requestFilter, page, size);
    }

    public ApiDetailsResponse getApis(String dsId) throws DsmException {
        List apis = this.dsDao.getApis(dsId);
        List api = apis.stream().map(ConversionUtils::asDetails).collect(Collectors.toList());
        return ResponseUtils.apiResponse(api, (long)api.size());
    }

    public void setManaged(String dsId, boolean managed) throws DsmException {
        log.info((Object)String.format("updated api '%s' managed with '%s'", dsId, managed));
        this.dsDao.setManaged(dsId, managed);
    }

    public boolean isManaged(String dsId) throws DsmException {
        return this.dsDao.isManaged(dsId);
    }

    public boolean exist(DatasourceDetails d) throws DsmException {
        return ((DatasourceDaoImpl)this.dsDao).existDs(d.getId());
    }

    public void save(DatasourceDetails d) throws DsmException {
        this.dsDao.saveDs((Datasource)ConversionUtils.asDbEntry((DatasourceDetails)d));
        this.isClient.registerDS(d);
    }

    public void updateDatasourcename(String dsId, String officialname, String englishname) throws DsmException {
        log.info((Object)String.format("updated datasource '%s' with officialname '%s' and englishname '%s'", dsId, officialname, englishname));
        this.dsDao.updateName(dsId, officialname, englishname);
        HashMap changes = Maps.newHashMap();
        changes.put("//CONFIGURATION/OFFICIAL_NAME", XmlEscapers.xmlContentEscaper().escape(officialname));
        changes.put("//CONFIGURATION/ENGLISH_NAME", XmlEscapers.xmlContentEscaper().escape(englishname));
        this.isClient.updateDatasourceFields(dsId, (Map)changes);
    }

    public void updateDatasourceLogoUrl(String dsId, String logourl) throws DsmException {
        log.info((Object)String.format("updated datasource '%s' with logo URL '%s'", dsId, logourl));
        this.dsDao.updateLogoUrl(dsId, logourl);
    }

    public void updateCoordinates(String dsId, Double latitude, Double longitude) throws DsmException {
        log.info((Object)String.format("updated datasource '%s' with coordinates Lat:'%s', Lon:'%s'", dsId, latitude, longitude));
        this.dsDao.updateCoordinates(dsId, latitude, longitude);
        HashMap changes = Maps.newHashMap();
        changes.put("//CONFIGURATION/LOCATION/LATITUDE", XmlEscapers.xmlContentEscaper().escape(String.valueOf(latitude)));
        changes.put("//CONFIGURATION/LOCATION/LONGITUDE", XmlEscapers.xmlContentEscaper().escape(String.valueOf(longitude)));
        this.isClient.updateDatasourceFields(dsId, (Map)changes);
    }

    public void updateTimezone(String dsId, String timezone) throws DsmException {
        log.info((Object)String.format("updated datasource '%s' timezone with '%s'", dsId, timezone));
        this.dsDao.updateTimezone(dsId, timezone);
        HashMap changes = Maps.newHashMap();
        changes.put("//CONFIGURATION/LOCATION/TIMEZONE", XmlEscapers.xmlContentEscaper().escape(timezone));
        this.isClient.updateDatasourceFields(dsId, (Map)changes);
    }

    public void updateDsTypology(String dsId, String typology) throws DsmException {
        log.info((Object)String.format("updated datasource '%s' typology with '%s'", dsId, typology));
        this.dsDao.updateTypology(dsId, typology);
        HashMap changes = Maps.newHashMap();
        changes.put("//CONFIGURATION/DATASOURCE_TYPE", XmlEscapers.xmlContentEscaper().escape(typology));
        this.isClient.updateDatasourceFields(dsId, (Map)changes);
    }

    public void updateDsRegisteringUser(String dsId, String registeredBy) throws DsmException {
        log.info((Object)String.format("updated datasource '%s' registering user with '%s'", dsId, registeredBy));
        this.dsDao.updateRegisteringUser(dsId, registeredBy);
    }

    public void updateDsPlatform(String dsId, String platform) throws DsmException {
        log.info((Object)String.format("updated datasource '%s' platform with '%s'", dsId, platform));
        this.dsDao.updatePlatform(dsId, platform);
        HashMap changes = Maps.newHashMap();
        changes.put("//CONFIGURATION/TYPOLOGY", XmlEscapers.xmlContentEscaper().escape(platform));
        this.isClient.updateDatasourceFields(dsId, (Map)changes);
    }

    public void deleteDs(String dsId) throws DsmException {
        log.info((Object)String.format("deleted datasource '%s'", dsId));
        this.dsDao.deleteDs(dsId);
    }

    public void updateApiBaseurl(String dsId, String apiId, String baseUrl) throws DsmException {
        log.info((Object)String.format("updated api '%s' baseurl with '%s'", apiId, baseUrl));
        this.dsDao.updateApiBaseUrl(apiId, baseUrl);
        HashMap changes = Maps.newHashMap();
        changes.put("/BASE_URL", XmlEscapers.xmlContentEscaper().escape(baseUrl));
        this.isClient.updateAPIField(dsId, apiId, (Map)changes);
    }

    public void updateApiCompatibility(String dsId, String apiId, String compliance, boolean override) throws DsmException {
        log.info((Object)String.format("updated api '%s' compliance with '%s'", apiId, compliance));
        this.dsDao.updateCompliance(null, apiId, compliance, override);
        HashMap changes = Maps.newHashMap();
        changes.put("/@compliance", XmlEscapers.xmlAttributeEscaper().escape(compliance));
        this.isClient.updateAPIField(dsId, apiId, (Map)changes);
    }

    public void addApi(ApiDetails api) throws DsmException {
        if (StringUtils.isBlank((CharSequence)api.getId())) {
            api.setId(ConversionUtils.createId((ApiDetails)api));
            log.info((Object)String.format("missing api id, created '%s'", api.getId()));
        }
        this.dsDao.addApi((Api)ConversionUtils.asDbEntry((ApiDetails)api));
        this.isClient.registerAPI(api);
    }

    public void deleteApi(String apiId) throws DsmForbiddenException, DsmException {
        this.isClient.removeAPI(apiId);
        this.dsDao.deleteApi(null, apiId);
    }

    public void dropCaches() {
        this.mongoLoggerClient.dropCache();
        this.isClient.dropCache();
        this.vocabularyClient.dropCache();
    }

    private DatasourceInfo enrichDatasourceInfo(DatasourceDetails d, CountDownLatch outerLatch, Queue<Throwable> errors) {
        DatasourceInfo dsInfo = new DatasourceInfo().setDatasource(d);
        this.getAggregationHistory(d.getId(), outerLatch, errors, dsInfo);
        this.getIndexDsInfo(d.getId(), outerLatch, errors, dsInfo);
        return dsInfo;
    }

    private void getAggregationHistory(String dsId, CountDownLatch outerLatch, Queue<Throwable> errors, DatasourceInfo datasourceInfo) {
        Futures.addCallback((ListenableFuture)this.executor.submit(() -> this.mongoLoggerClient.getAggregationHistory(dsId)), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.executor);
    }

    private void setAggregationHistory(DatasourceInfo datasourceInfo, List<AggregationInfo> info) {
        datasourceInfo.setAggregationHistory(info);
        if (!info.isEmpty()) {
            datasourceInfo.setLastCollection(info.stream().filter(a -> AggregationStage.COLLECT.equals((Object)a.getAggregationStage())).findFirst().get()).setLastTransformation(info.stream().filter(a -> AggregationStage.TRANSFORM.equals((Object)a.getAggregationStage())).findFirst().get());
        }
    }

    private void getIndexDsInfo(String dsId, CountDownLatch outerLatch, Queue<Throwable> errors, DatasourceInfo datasourceInfo) {
        Futures.addCallback((ListenableFuture)this.executor.submit(() -> this.isClient.calculateCurrentIndexDsInfo()), (FutureCallback)new /* Unavailable Anonymous Inner Class!! */, (Executor)this.executor);
    }

    private void waitLatch(CountDownLatch latch, Queue<Throwable> errors, int waitSeconds) {
        try {
            if (!latch.await(waitSeconds, TimeUnit.SECONDS)) {
                errors.offer(new TimeoutException("Waiting for requests to complete has timed out."));
            }
        }
        catch (InterruptedException e) {
            errors.offer(e);
        }
    }

    static /* synthetic */ void access$000(DatasourceManagerCore x0, DatasourceInfo x1, List x2) {
        x0.setAggregationHistory(x1, x2);
    }

    static /* synthetic */ Log access$100() {
        return log;
    }

    static /* synthetic */ ListeningExecutorService access$200(DatasourceManagerCore x0) {
        return x0.executor;
    }

    static /* synthetic */ OpenaireExporterConfig access$300(DatasourceManagerCore x0) {
        return x0.config;
    }

    static /* synthetic */ void access$400(DatasourceManagerCore x0, CountDownLatch x1, Queue x2, int x3) {
        x0.waitLatch(x1, x2, x3);
    }

    static /* synthetic */ ISClient access$500(DatasourceManagerCore x0) {
        return x0.isClient;
    }

    static /* synthetic */ ObjectStoreClient access$600(DatasourceManagerCore x0) {
        return x0.objectStoreClient;
    }

    static /* synthetic */ DatasourceIndexClient access$700(DatasourceManagerCore x0) {
        return x0.datasourceIndexClient;
    }
}

