/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.datasource.clients;

import com.google.common.collect.Lists;
import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.openaire.exporter.datasource.clients.DatasourceDao;
import eu.dnetlib.openaire.exporter.datasource.clients.VocabularyClient;
import eu.dnetlib.openaire.exporter.datasource.repository.ApiDbEntryRepository;
import eu.dnetlib.openaire.exporter.datasource.repository.CountryTermRepository;
import eu.dnetlib.openaire.exporter.datasource.repository.DatasourceApiDbEntryRepository;
import eu.dnetlib.openaire.exporter.datasource.repository.DatasourceDbEntryRepository;
import eu.dnetlib.openaire.exporter.datasource.repository.DatasourceSpecs;
import eu.dnetlib.openaire.exporter.model.datasource.RequestFilter;
import eu.dnetlib.openaire.exporter.model.datasource.RequestSort;
import eu.dnetlib.openaire.exporter.model.datasource.RequestSortOrder;
import eu.dnetlib.openaire.exporter.model.datasource.db.ApiDbEntry;
import eu.dnetlib.openaire.exporter.model.datasource.db.DatasourceApiDbEntry;
import eu.dnetlib.openaire.exporter.model.datasource.db.DatasourceDbEntry;
import eu.dnetlib.openaire.exporter.vocabularies.Country;
import eu.dnetlib.openaire.exporter.vocabularies.Vocabulary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class DatasourceDaoImpl
implements DatasourceDao<DatasourceDbEntry, ApiDbEntry> {
    private static final Log log = LogFactory.getLog(DatasourceDao.class);
    @Autowired
    private OpenaireExporterConfig config;
    @Autowired
    private CountryTermRepository countryTermRepository;
    @Autowired
    private DatasourceDbEntryRepository dsRepository;
    @Autowired
    private ApiDbEntryRepository apiRepository;
    @Autowired
    private DatasourceApiDbEntryRepository dsApiRepository;
    @Autowired
    private VocabularyClient vocabularyClient;

    public List<Country> listCountries() throws DsmException {
        ArrayList countries = Lists.newArrayList();
        Vocabulary v = this.vocabularyClient.getCountries();
        countries.addAll(this.countryTermRepository.findAll().stream().filter(Objects::nonNull).map(t -> new Country(t.getTerm(), v.getEnglishName(t.getTerm()))).collect(Collectors.toList()));
        return countries;
    }

    public Page<DatasourceDbEntry> search(RequestSort requestSortBy, RequestSortOrder order, RequestFilter requestFilter, int page, int size) throws DsmException {
        Specification spec = DatasourceSpecs.dsSpec((RequestSort)requestSortBy, (RequestSortOrder)order, (RequestFilter)requestFilter);
        return this.dsRepository.findAll(spec, (Pageable)new PageRequest(page, size));
    }

    public DatasourceDbEntry getDs(String dsId) throws DsmException {
        return (DatasourceDbEntry)this.dsRepository.findOne((Serializable)((Object)dsId));
    }

    public void setManaged(String id, boolean managed) {
        log.info((Object)String.format("setting managed = '%s' for ds '%s'", managed, id));
        this.dsRepository.setManaged(id, managed);
    }

    public boolean isManaged(String id) {
        return this.dsRepository.isManaged(id);
    }

    public void updateCompliance(String dsId, String apiId, String compliance, boolean override) {
        log.info((Object)String.format("setting compatibility = '%s' for ds '%s'", compliance, apiId));
        this.apiRepository.updateCompatibility(apiId, compliance);
    }

    public List<ApiDbEntry> getApis(String dsId) {
        return this.apiRepository.findByDatasource(dsId);
    }

    public void deleteApi(String dsId, String apiId) throws DsmException {
        ApiDbEntry api = (ApiDbEntry)this.apiRepository.findOne((Serializable)((Object)apiId));
        if (!api.getRemovable().booleanValue()) {
            throw new DsmException(401, "api is not removable");
        }
        this.apiRepository.delete((Serializable)((Object)apiId));
        log.info((Object)String.format("deleted api '%s'", apiId));
    }

    public void addApi(ApiDbEntry api) {
        this.apiRepository.save((Object)api);
    }

    public boolean existDs(String dsId) throws DsmException {
        return this.dsRepository.findOneById(dsId) != null;
    }

    public void saveDs(DatasourceDbEntry d) {
        log.info((Object)String.format("saving datasource '%s'", d.getId()));
        DatasourceDbEntry datasource = (DatasourceDbEntry)this.dsRepository.save((Object)d);
        log.info((Object)String.format("saved datasource '%s'", datasource.getId()));
    }

    public void deleteDs(String dsId) {
        this.dsRepository.delete((Serializable)((Object)dsId));
        log.info((Object)String.format("deleted datasource '%s'", dsId));
    }

    public void updateName(String dsId, String officialname, String englishname) {
        this.dsRepository.setDatasourcename(dsId, officialname, englishname);
    }

    public void updateLogoUrl(String dsId, String logourl) throws DsmException {
        this.dsRepository.setLogoUrl(dsId, logourl);
    }

    public void updateCoordinates(String dsId, Double latitude, Double longitude) {
        this.dsRepository.setCoordinates(dsId, latitude, longitude);
    }

    public void updateApiBaseUrl(String apiId, String baseurl) {
        this.apiRepository.setBaseurl(apiId, baseurl);
    }

    public List<String> findApiBaseURLs(RequestFilter requestFilter, int page, int size) throws DsmException {
        PageRequest pageable = new PageRequest(page, size);
        Specification spec = DatasourceSpecs.apiSpec((RequestFilter)requestFilter);
        Set set = this.dsApiRepository.findAll(spec, (Pageable)pageable).getContent().stream().map(DatasourceApiDbEntry::getBaseurl).filter(StringUtils::isNotBlank).collect(Collectors.toCollection(HashSet::new));
        return Lists.newArrayList((Iterable)set);
    }

    public void updateTimezone(String dsId, String timezone) {
        this.dsRepository.setTimezone(dsId, timezone);
    }

    public void updateTypology(String dsId, String typology) throws DsmException {
        Vocabulary typologies = this.vocabularyClient.getDatasourceTypologies();
        if (!typologies.hasCode(typology)) {
            throw new DsmException(400, String.format("invalid datasource typology '%s', provide one according to vocabulary %s", typology, this.config.getVocabularies().getDatasourceTypologiesEndpoint()));
        }
        this.dsRepository.setTypology(dsId, typology);
    }

    public void updateRegisteringUser(String dsId, String registeredBy) throws DsmException {
        this.dsRepository.setRegisteringUser(dsId, registeredBy);
    }

    public void updatePlatform(String dsId, String platform) throws DsmException {
        this.dsRepository.setPlatform(dsId, platform);
    }
}

