/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.datasource.clients;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.enabling.datasources.common.AggregationInfo;
import eu.dnetlib.enabling.datasources.common.AggregationStage;
import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.openaire.exporter.Utils;
import eu.dnetlib.openaire.exporter.datasource.clients.MongoLoggerClient;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MongoLoggerClientImpl
implements MongoLoggerClient {
    private static final Log log = LogFactory.getLog(MongoLoggerClientImpl.class);
    @Autowired
    private MongoClient datasourcePublisherMongoClient;
    @Autowired
    private OpenaireExporterConfig config;
    private static Bson fields = MongoLoggerClientImpl.getFields();
    private static MongoCollection<Document> collection = null;

    @Cacheable(value={"datasources-mongo-cache"})
    public List<AggregationInfo> getAggregationHistory(String dsId) throws DsmException {
        log.warn((Object)String.format("getAggregationHistory(dsId = %s): not using cache", dsId));
        OpenaireExporterConfig.Datasource conf = this.config.getDatasource();
        Instant loadTime = Instant.parse(((Document)this.getCollection().find(this.queryForLastMetadataLoad()).sort((Bson)MongoLoggerClientImpl.dbo((String)"system:startHumanDate", (Object)-1)).first()).getString((Object)"system:startHumanDate").replaceAll("\\+.*", "Z"));
        FindIterable aggregationDocs = this.getCollection().find(this.queryForAggregationHistory(dsId)).projection(fields).limit(conf.getMongoQueryLimit()).sort((Bson)MongoLoggerClientImpl.dbo((String)"system:startHumanDate", (Object)-1));
        List<AggregationInfo> aggregationInfos = Utils.stream((Iterator)aggregationDocs.iterator()).map(this.getMapper()).filter(ai -> ai.getNumberOfRecords() >= 0 && StringUtils.isNotBlank((String)ai.getDate())).collect(Collectors.toList());
        for (AggregationInfo a : aggregationInfos) {
            if (!this.asInstant(a).isBefore(loadTime) || !AggregationStage.COLLECT.equals((Object)a.getAggregationStage())) continue;
            a.setIndexedVersion(true);
            break;
        }
        return aggregationInfos;
    }

    private Instant asInstant(AggregationInfo a) {
        return Instant.parse(a.getDate() + "T00:00:00Z");
    }

    @CacheEvict(cacheNames={"datasources-mongo-cache"}, allEntries=true)
    public void dropCache() {
        log.info((Object)"dropped dsManager aggregation history cache");
    }

    private Function<Document, AggregationInfo> getMapper() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private String getDate(Document d) {
        String dateString = d.getString((Object)"system:startHumanDate");
        if (StringUtils.isBlank((String)dateString)) {
            return "";
        }
        return DateFormatUtils.format((Date)new DateUtils().parse(dateString), (String)"yyyy-MM-dd");
    }

    private static Bson getFields() {
        return Projections.fields((Bson[])new Bson[]{Filters.eq((String)"system:wfName", (Object)1), Filters.eq((String)"system:node:SELECT_MODE:selection", (Object)1), Filters.eq((String)"mainlog:sinkSize", (Object)1), Filters.eq((String)"mainlog:writeOps", (Object)1), Filters.eq((String)"mainlog:total", (Object)1), Filters.eq((String)"system:startHumanDate", (Object)1), Filters.eq((String)"system:profileName", (Object)1)});
    }

    private static BasicDBObject dbo(String key, Object value) {
        return new BasicDBObject(key, value);
    }

    private Bson queryForAggregationHistory(String dsId) {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"parentDatasourceId", (Object)dsId), Filters.eq((String)"system:profileFamily", (Object)"aggregator"), Filters.eq((String)"system:isCompletedSuccessfully", (Object)"true"), Filters.regex((String)"system:wfName", (String)"(collect|transform)", (String)"i")});
    }

    private Bson queryForLastMetadataLoad() {
        return Filters.and((Bson[])new Bson[]{Filters.eq((String)"system:profileId", (Object)this.config.getOaf2HBaseWfId()), Filters.eq((String)"system:isCompletedSuccessfully", (Object)"true"), Filters.eq((String)"system:node:reuseHdfsRecords:reuseMdRecords", (Object)"false")});
    }

    private synchronized MongoCollection<Document> getCollection() {
        if (collection == null) {
            log.info((Object)"inizializing mongodb collection ...");
            OpenaireExporterConfig.Datasource conf = this.config.getDatasource();
            collection = this.datasourcePublisherMongoClient.getDatabase(conf.getMongoDbName()).getCollection(conf.getMongoCollectionName());
        }
        return collection;
    }

    static /* synthetic */ String access$000(MongoLoggerClientImpl x0, Document x1) {
        return x0.getDate(x1);
    }
}

