/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.datasource.clients;

import eu.dnetlib.data.objectstore.rmi.ObjectStoreService;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.openaire.exporter.datasource.clients.ObjectStoreClient;
import java.util.Queue;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ObjectStoreClientImpl
implements ObjectStoreClient {
    private static final Log log = LogFactory.getLog(ObjectStoreClientImpl.class);
    @Autowired
    private ObjectStoreService objectStoreService;

    public Long getObjectStoreSize(String objectStoreId, Queue<Throwable> errors) {
        log.debug((Object)("get size for objectStore " + objectStoreId));
        if (StringUtils.isBlank((String)objectStoreId)) {
            return 0L;
        }
        try {
            long size = this.objectStoreService.getSize(objectStoreId);
            log.debug((Object)("got objectStore size: " + size));
            return size;
        }
        catch (ObjectStoreServiceException e) {
            errors.add(e);
            return 0L;
        }
    }
}

