/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.funders;

import eu.dnetlib.openaire.exporter.funders.FunderRepository;
import eu.dnetlib.openaire.exporter.funders.FundersApiException;
import eu.dnetlib.openaire.exporter.funders.model.ConversionUtils;
import eu.dnetlib.openaire.exporter.funders.model.ExtendedFunderDetails;
import eu.dnetlib.openaire.exporter.funders.model.FunderDetails;
import eu.dnetlib.openaire.exporter.funders.model.db.FunderDbEntry;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class FunderDao {
    private static final Log log = LogFactory.getLog(FunderDao.class);
    @Autowired
    private FunderRepository funderRepository;

    public ExtendedFunderDetails getExtendedFunderDetails(String funderId) throws FundersApiException {
        return ConversionUtils.asExtendedFunderDetails((FunderDbEntry)((FunderDbEntry)this.funderRepository.getOne((Serializable)((Object)funderId))));
    }

    public List<FunderDetails> listFunderDetails(int page, int size) throws FundersApiException {
        return this.funderRepository.findAll((Pageable)new PageRequest(page, size)).getContent().stream().map(ConversionUtils::asFunderDetails).collect(Collectors.toList());
    }

    public List<String> listFunderIds(int page, int size) throws FundersApiException {
        return this.funderRepository.findAll((Pageable)new PageRequest(page, size)).getContent().stream().map(f -> f.getId()).collect(Collectors.toList());
    }
}

