/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.data.transform.xml.AbstractDNetXsltFunctions;
import eu.dnetlib.enabling.datasources.common.Api;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.openaire.exporter.model.datasource.ApiDetails;
import eu.dnetlib.openaire.exporter.model.datasource.DatasourceDetails;
import eu.dnetlib.openaire.exporter.model.datasource.OrganizationDetails;
import eu.dnetlib.openaire.exporter.model.datasource.db.ApiDbEntry;
import eu.dnetlib.openaire.exporter.model.datasource.db.DatasourceDbEntry;
import java.sql.Date;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConversionUtils {
    public static final String ID_SEPARATOR = "::";
    public static final String ID_PREFIX = "api_________::";

    public static String createId(ApiDetails api) {
        return "api_________::" + api.getDatasource() + "::" + RandomStringUtils.randomAlphanumeric((int)8);
    }

    public static DatasourceDetails asDetails(DatasourceDbEntry d) {
        DatasourceDetails details = (DatasourceDetails)ConversionUtils._convert((Object)d, DatasourceDetails.class);
        return details.setOpenaireId(ConversionUtils.asOpenaireId((String)details.getId()));
    }

    public static ApiDetails asDetails(ApiDbEntry d) {
        return (ApiDetails)ConversionUtils._convert((Object)d, ApiDetails.class);
    }

    public static ApiDbEntry asDbEntry(ApiDetails d) {
        ApiDbEntry apiDbEntry = (ApiDbEntry)ConversionUtils._convert((Object)d, ApiDbEntry.class);
        apiDbEntry.getApiParams().forEach(ap -> ap.getId().setApi((Api)apiDbEntry));
        return apiDbEntry;
    }

    public static DatasourceDbEntry asDbEntry(DatasourceDetails d) {
        DatasourceDbEntry dbe = (DatasourceDbEntry)ConversionUtils._convert((Object)d, DatasourceDbEntry.class);
        if (dbe.getOrganizations() != null) {
            dbe.getOrganizations().forEach(o -> {
                o.setId(dbe.getId() + "::" + o.getLegalname());
                if (o.getDateofcollection() == null) {
                    o.setDateofcollection(new Date(System.currentTimeMillis()));
                }
            });
        }
        return dbe;
    }

    public static String asRepositoryProfile(DatasourceDetails ds) {
        Element root = DocumentHelper.createElement((String)"RESOURCE_PROFILE");
        Element header = root.addElement("HEADER");
        header.addElement("RESOURCE_IDENTIFIER").addAttribute("value", "");
        header.addElement("RESOURCE_TYPE").addAttribute("value", "RepositoryServiceResourceType");
        header.addElement("RESOURCE_KIND").addAttribute("value", "RepositoryServiceResources");
        header.addElement("RESOURCE_URI").addAttribute("value", "");
        header.addElement("DATE_OF_CREATION").addAttribute("value", DateUtils.now_ISO8601());
        header.addElement("PROTOCOL");
        Element body = root.addElement("BODY");
        Element conf = body.addElement("CONFIGURATION");
        conf.addElement("DATASOURCE_TYPE").setText(ds.getTypology());
        Element origId = conf.addElement("DATASOURCE_ORIGINAL_ID");
        origId.addAttribute("provenance", "D-NET");
        origId.setText(ds.getId());
        conf.addElement("DATASOURCE_AGGREGATED").setText("false");
        conf.addElement("ENVIRONMENTS").addElement("ENVIRONMENT").setText("OPENAIRE");
        conf.addElement("TYPOLOGY").setText("" + ds.getTypology());
        conf.addElement("MAX_SIZE_OF_DATASTRUCTURE").setText("0");
        conf.addElement("AVAILABLE_DISKSPACE").setText("0");
        conf.addElement("MAX_NUMBER_OF_DATASTRUCTURE").setText("0");
        String officialName = ds.getOfficialname();
        conf.addElement("OFFICIAL_NAME").setText(officialName);
        String englishName = ds.getEnglishname();
        conf.addElement("ENGLISH_NAME").setText(StringUtils.isNotBlank((CharSequence)englishName) ? englishName : officialName);
        conf.addElement("ICON_URI").setText("" + ds.getLogourl());
        OrganizationDetails org = ConversionUtils.getOrganization((DatasourceDetails)ds);
        conf.addElement("COUNTRY").setText(org != null ? org.getCountry() : "");
        Element location = conf.addElement("LOCATION");
        location.addElement("LONGITUDE").setText("" + ds.getLongitude());
        location.addElement("LATITUDE").setText("" + ds.getLatitude());
        location.addElement("TIMEZONE").setText("" + ds.getTimezone());
        conf.addElement("REPOSITORY_WEBPAGE").setText(ds.getWebsiteurl());
        ConversionUtils.getOrganization((DatasourceDetails)ds);
        conf.addElement("REPOSITORY_INSTITUTION").setText(org != null ? org.getLegalname() : "");
        conf.addElement("ADMIN_INFO").setText(ds.getContactemail());
        conf.addElement("INTERFACES");
        Element extraFields = conf.addElement("EXTRA_FIELDS");
        ConversionUtils.addExtraField((Element)extraFields, (String)"ACTIVATION_ID", (String)ds.getActivationId());
        ConversionUtils.addExtraField((Element)extraFields, (String)"NamespacePrefix", (String)ds.getNamespaceprefix());
        ConversionUtils.addExtraField((Element)extraFields, (String)"aggregatorName", (String)ds.getAggregator());
        ConversionUtils.addExtraField((Element)extraFields, (String)"dateOfCollection", (String)("" + ds.getDateofcollection()));
        ConversionUtils.addExtraField((Element)extraFields, (String)"dateOfValidation", (String)("" + ds.getDateofvalidation()));
        conf.addElement("REGISTERED_BY").setText(ds.getRegisteredby());
        Element status = body.addElement("STATUS");
        status.addElement("NUMBER_OF_OBJECTS").setText("0");
        status.addElement("LAST_UPDATE").addAttribute("value", DateUtils.now_ISO8601());
        Element qos = body.addElement("QOS");
        qos.addElement("AVAILABILITY").setText("0");
        qos.addElement("CAPACITY");
        qos.addElement("THROUGHPUT").setText("0");
        body.addElement("SECURITY_PARAMETERS");
        body.addElement("BLACKBOARD");
        return root.asXML();
    }

    public static String asRepositoryInterfce(ApiDetails api) {
        Element iface = DocumentHelper.createElement((String)"INTERFACE");
        iface.addAttribute("active", String.valueOf(api.getActive())).addAttribute("compliance", api.getCompatibility()).addAttribute("contentDescription", api.getContentdescription()).addAttribute("id", api.getId()).addAttribute("label", String.format("%s (%s)", api.getTypology(), api.getCompatibility())).addAttribute("removable", String.valueOf(api.getRemovable())).addAttribute("typology", api.getTypology());
        iface.addElement("ACCESS_PROTOCOL").setText(api.getProtocol());
        if (api.getApiParams() != null) {
            Element accessProtocol = (Element)iface.selectSingleNode("./ACCESS_PROTOCOL");
            api.getApiParams().forEach(ap -> {
                if ("format".equals(ap.getParam())) {
                    accessProtocol.addAttribute("format", ap.getValue());
                }
                if ("set".equals(ap.getParam())) {
                    accessProtocol.addAttribute("set", ap.getValue());
                }
            });
        }
        iface.addElement("BASE_URL").setText(api.getBaseurl());
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "last_collection_date");
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "last_collection_mdId");
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "last_collection_total");
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "last_aggregation_date");
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "last_aggregation_mdId");
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "last_aggregation_total");
        iface.addElement("INTERFACE_EXTRA_FIELD").addAttribute("name", "metadata_identifier_path");
        return iface.asXML();
    }

    private static <T> T _convert(Object o, Class<T> clazz) {
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.convertValue(o, clazz);
    }

    private static OrganizationDetails getOrganization(DatasourceDetails ds) {
        if (ds.getOrganizations() != null && !ds.getOrganizations().isEmpty()) {
            return (OrganizationDetails)ds.getOrganizations().stream().findFirst().get();
        }
        return null;
    }

    private static void addExtraField(Element extraFields, String field, String value) {
        Element f = extraFields.addElement("FIELD");
        f.addElement("key").setText(field);
        f.addElement("value").setText(value != null ? value : "");
    }

    private static String asOpenaireId(String id) {
        String prefix = StringUtils.substringBefore((String)id, (String)"::");
        String md5 = StringUtils.substringAfter((String)id, (String)"::");
        return prefix + "::" + AbstractDNetXsltFunctions.md5((String)md5);
    }
}

