/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.model.project;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import java.sql.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="projects_tsv")
@ApiModel(value="Project TSV model", description="project TSV model description")
public class ProjectTsv {
    @Id
    @JsonIgnore
    private long rowid;
    private String code;
    private String acronym;
    private String title;
    @Column(name="call_identifier")
    private String callIdentifier;
    private Date startdate;
    private Date enddate;
    @Column(name="ec_sc39")
    private Boolean ecSc39;
    @Column(name="oa_mandate_for_publications")
    private Boolean oaMandateForPublications;
    @Column(name="oa_mandate_for_datasets")
    private Boolean oaMandateForDatasets;
    @JsonIgnore
    private String fundingpathid;
    private String description;
    @Column(name="legalname")
    private String orgLegalname;
    @Column(name="country")
    private String orgCountry;
    @Column(name="role")
    private String orgRole;
    private String contactfullname;
    private String contactemail;

    public List<String> asList() {
        return Lists.newArrayList((Object[])new String[]{this.clean(this.getCode()), this.clean(this.getAcronym()), this.clean(this.getTitle()), this.clean(this.getCallIdentifier()), this.clean(this.getStartdate() != null ? this.getStartdate().toString() : ""), this.clean(this.getEnddate() != null ? this.getEnddate().toString() : ""), this.clean(String.valueOf(this.isOaMandateForPublications())), this.clean(String.valueOf(this.isOaMandateForDatasets())), this.clean(this.getDescription()), this.clean(this.getOrgLegalname()), this.clean(this.getOrgCountry()), this.clean(this.getOrgRole()), this.clean(this.getContactfullname()), this.clean(this.getContactemail())});
    }

    private String clean(String s) {
        return StringUtils.isNotBlank((CharSequence)s) ? "\"" + s.replaceAll("\\n|\\t|\\s+", " ").replace("\"", "\"\"").trim() + "\"" : "";
    }

    public long getRowid() {
        return this.rowid;
    }

    public void setRowid(long rowid) {
        this.rowid = rowid;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getAcronym() {
        return this.acronym;
    }

    public void setAcronym(String acronym) {
        this.acronym = acronym;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCallIdentifier() {
        return this.callIdentifier;
    }

    public void setCallIdentifier(String callIdentifier) {
        this.callIdentifier = callIdentifier;
    }

    public Date getStartdate() {
        return this.startdate;
    }

    public void setStartdate(Date startdate) {
        this.startdate = startdate;
    }

    public Date getEnddate() {
        return this.enddate;
    }

    public void setEnddate(Date enddate) {
        this.enddate = enddate;
    }

    public Boolean isEcSc39() {
        return this.ecSc39;
    }

    public void setEcSc39(Boolean ecSc39) {
        this.ecSc39 = ecSc39;
    }

    public Boolean isOaMandateForPublications() {
        return this.oaMandateForPublications;
    }

    public void setOaMandateForPublications(Boolean oaMandateForPublications) {
        this.oaMandateForPublications = oaMandateForPublications;
    }

    public Boolean isOaMandateForDatasets() {
        return this.oaMandateForDatasets;
    }

    public void setOaMandateForDatasets(Boolean oaMandateForDatasets) {
        this.oaMandateForDatasets = oaMandateForDatasets;
    }

    public String getFundingpathid() {
        return this.fundingpathid;
    }

    public void setFundingpathid(String fundingpathid) {
        this.fundingpathid = fundingpathid;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrgLegalname() {
        return this.orgLegalname;
    }

    public void setOrgLegalname(String orgLegalname) {
        this.orgLegalname = orgLegalname;
    }

    public String getOrgCountry() {
        return this.orgCountry;
    }

    public void setOrgCountry(String orgCountry) {
        this.orgCountry = orgCountry;
    }

    public String getOrgRole() {
        return this.orgRole;
    }

    public void setOrgRole(String orgRole) {
        this.orgRole = orgRole;
    }

    public String getContactfullname() {
        return this.contactfullname;
    }

    public void setContactfullname(String contactfullname) {
        this.contactfullname = contactfullname;
    }

    public String getContactemail() {
        return this.contactemail;
    }

    public void setContactemail(String contactemail) {
        this.contactemail = contactemail;
    }
}

