/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.openaire.exporter.vocabularies;

import com.google.common.collect.Maps;
import eu.dnetlib.openaire.exporter.vocabularies.Term;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Vocabulary {
    private static final Log log = LogFactory.getLog(Vocabulary.class);
    private List<Term> terms;
    private static Map<String, Term> byCode = Maps.newConcurrentMap();

    public String getEnglishName(String code) {
        Term term;
        if (byCode.isEmpty()) {
            this.hashByCode();
        }
        return (term = (Term)byCode.get(code)) != null ? term.getEnglishName() : null;
    }

    public boolean hasCode(String code) {
        return this.getEnglishName(code) != null;
    }

    private void hashByCode() {
        log.info((Object)"hashing vocabulary by code ...");
        this.getTerms().forEach(term -> byCode.put(term.getCode(), term));
        log.info((Object)"hashing vocabulary by code ... done!");
    }

    public List<Term> getTerms() {
        return this.terms;
    }

    public void setTerms(List<Term> terms) {
        this.terms = terms;
    }
}

