/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.swagger.configuration;

import eu.dnetlib.OpenaireExporterConfig;
import eu.dnetlib.openaire.exporter.community.CommunityApiController;
import eu.dnetlib.openaire.exporter.datasource.DatasourcesApiController;
import eu.dnetlib.openaire.exporter.funders.FundersApiController;
import eu.dnetlib.openaire.exporter.project.ProjectsController;
import java.sql.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerDocumentationConfig {
    private static final Log log = LogFactory.getLog(SwaggerDocumentationConfig.class);
    @Autowired
    private OpenaireExporterConfig config;

    @Bean
    public Docket dsm() {
        return this._docket("Datasource Manager", DatasourcesApiController.class.getPackage().getName(), this.config.getSwaggerDsm());
    }

    @Bean
    public Docket projects() {
        return this._docket("OpenAIRE Projects", ProjectsController.class.getPackage().getName(), this.config.getSwaggerProjects());
    }

    @Bean
    public Docket funders() {
        return this._docket("OpenAIRE Funders", FundersApiController.class.getPackage().getName(), this.config.getSwaggerFunders());
    }

    @Bean
    public Docket communities() {
        return this._docket("OpenAIRE Communities", CommunityApiController.class.getPackage().getName(), this.config.getSwaggerCommunities());
    }

    private Docket _docket(String groupName, String controllerPackage, OpenaireExporterConfig.Swagger swag) {
        return new Docket(DocumentationType.SWAGGER_2).groupName(groupName).select().apis(RequestHandlerSelectors.basePackage((String)controllerPackage)).build().directModelSubstitute(LocalDate.class, Date.class).directModelSubstitute(DateTime.class, java.util.Date.class).apiInfo(this.apiInfo(swag));
    }

    private ApiInfo apiInfo(OpenaireExporterConfig.Swagger swag) {
        return new ApiInfoBuilder().title(swag.getApiTitle()).description(swag.getApiDescription()).license(swag.getApiLicense()).licenseUrl(swag.getApiLicenseUrl()).termsOfServiceUrl("").version("1.0.0").contact(new Contact(swag.getApiContactName(), swag.getApiContactUrl(), swag.getApiContactEmail())).build();
    }
}

