package eu.dnetlib.openaire.common;

import java.io.IOException;
import java.util.Map;
import java.util.Queue;

import eu.dnetlib.enabling.datasources.common.DsmException;
import eu.dnetlib.enabling.datasources.common.DsmForbiddenException;
import eu.dnetlib.openaire.dsm.dao.utils.IndexDsInfo;
import eu.dnetlib.openaire.context.Context;
import eu.dnetlib.openaire.dsm.domain.ApiDetails;
import eu.dnetlib.openaire.dsm.domain.DatasourceDetails;

public interface ISClient {

	IndexDsInfo calculateCurrentIndexDsInfo() throws DsmException;

	String getObjectStoreId(String dsId, Queue<Throwable> errors) throws IOException;

	Map<String, Context> getFunderContextMap() throws IOException;

	Map<String, Context> getCommunityContextMap() throws IOException;

	void updateContextParam(String id, String name, String value);

	void updateContextAttribute(String id, String name, String value);

	void addConcept(String id, String categoryId, String data);

	void removeConcept(String id, String categoryId, String conceptId);

	void updateDatasourceFields(String dsId, Map<String, String> changes);

	void updateAPIField(String dsId, String apiId, Map<String, String> changes);

	void registerDS(DatasourceDetails d);

	void registerAPI(ApiDetails api);

	void removeAPI(String apiId) throws DsmForbiddenException;

	void dropCache();

}
