package eu.dnetlib.openaire.dsm.dao;

import java.util.Queue;

import eu.dnetlib.data.objectstore.rmi.ObjectStoreService;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ObjectStoreClientImpl implements ObjectStoreClient {

	private static final Log log = LogFactory.getLog(ObjectStoreClientImpl.class);

	@Autowired
	private ObjectStoreService objectStoreService;

	@Override
	public Long getObjectStoreSize(final String objectStoreId, final Queue<Throwable> errors) {
		log.debug("get size for objectStore " + objectStoreId);
		if (StringUtils.isBlank(objectStoreId)) {
			return 0L;
		}
		try {
			final long size = objectStoreService.getSize(objectStoreId);
			log.debug("got objectStore size: " + size);
			return size;
		} catch (ObjectStoreServiceException e) {
			errors.add(e);
			return 0L;
		}
	}

}
